/*
 * Decompiled with CFR 0.152.
 */
package org.infinitenature.herbariorum.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinitenature.herbariorum.client.Client;
import org.infinitenature.herbariorum.client.Herbariorum;
import org.infinitenature.herbariorum.entities.Institution;
import org.infinitenature.herbariorum.helper.InstitutionComparator;
import org.infinitenature.herbariorum.resource.CountryResource;
import org.infinitenature.herbariorum.resource.InstitutionResource;
import org.infinitenature.herbariorum.response.CountryResponse;
import org.infinitenature.herbariorum.response.InstitutionResponse;

public class HerbariorumInstantClient
implements Client {
    private Map<String, List<Institution>> institutionsByCountryAndName = new HashMap<String, List<Institution>>();
    private Map<String, Integer> countInstitutionsByCountryAndName = new HashMap<String, Integer>();
    private Map<String, List<String>> countriesByName = new HashMap<String, List<String>>();
    private Map<String, Integer> countCountriesByName = new HashMap<String, Integer>();
    private Herbariorum herbariorum = new Herbariorum("http://sweetgum.nybg.org");

    @Override
    public List<Institution> findInstitutionsByCountryAndName(String country, String name) {
        if (country == null) {
            return new ArrayList<Institution>();
        }
        if (this.institutionsByCountryAndName.get(country + name) != null) {
            return this.institutionsByCountryAndName.get(country + name);
        }
        InstitutionResource institutionResource = this.herbariorum.institutions();
        InstitutionResponse institutionResponse = institutionResource.findByCountry(country);
        List<Institution> institutions = institutionResponse.getInstitutions().stream().filter(institution -> institution.getOrganization().contains(name)).collect(Collectors.toList());
        Collections.sort(institutions, new InstitutionComparator());
        this.institutionsByCountryAndName.put(country + name, institutions);
        return institutions;
    }

    @Override
    public int countInstitutionsByCountryAndName(String country, String name) {
        if (country == null) {
            return 0;
        }
        if (this.countInstitutionsByCountryAndName.get(country + name) != null) {
            return this.countInstitutionsByCountryAndName.get(country + name);
        }
        InstitutionResource institutionResource = this.herbariorum.institutions();
        InstitutionResponse institutionResponse = institutionResource.findByCountry(country);
        int numberOfInstitutions = (int)institutionResponse.getInstitutions().stream().filter(institution -> institution.getOrganization().contains(name)).count();
        this.countInstitutionsByCountryAndName.put(country + name, numberOfInstitutions);
        return numberOfInstitutions;
    }

    @Override
    public List<String> findCountriesByName(String name) {
        if (this.countriesByName.get(name) != null) {
            return this.countriesByName.get(name);
        }
        CountryResource countryResource = this.herbariorum.countries();
        CountryResponse countryResponse = countryResource.findCountries();
        List<String> countries = countryResponse.getCountries().stream().filter(country -> country.contains(name)).collect(Collectors.toList());
        this.countriesByName.put(name, countries);
        return countries;
    }

    @Override
    public int countCountriesByName(String name) {
        if (this.countCountriesByName.get(name) != null) {
            return this.countCountriesByName.get(name);
        }
        CountryResource countryResource = this.herbariorum.countries();
        CountryResponse countryResponse = countryResource.findCountries();
        int numberOfCountries = (int)countryResponse.getCountries().stream().filter(country -> country.contains(name)).count();
        this.countCountriesByName.put(name, numberOfCountries);
        return numberOfCountries;
    }

    @Override
    public void setHerbariorum(Herbariorum herbariorum) {
        this.herbariorum = herbariorum;
    }

    @Override
    public void setInstitutions(List<Institution> institutions) {
    }

    @Override
    public void setCountries(Collection<String> countries) {
    }

    @Override
    public void setGermanCountries() {
    }
}

