/*
 * Decompiled with CFR 0.152.
 */
package org.infinitenature.herbariorum.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.infinitenature.herbariorum.client.HerbariorumMemoryClient;
import org.infinitenature.herbariorum.entities.Institution;
import org.infinitenature.herbariorum.helper.Translator;

public class HerbariorumGermanClient
extends HerbariorumMemoryClient {
    private Translator translator = new Translator();
    private Collection<String> germanCountries = new ArrayList<String>();

    public HerbariorumGermanClient() {
        for (String englishCountry : this.countries) {
            this.germanCountries.add(this.translator.translateEnglishToGerman(englishCountry));
        }
    }

    @Override
    public List<Institution> findInstitutionsByCountryAndName(String germanCountry, String name) {
        return super.findInstitutionsByCountryAndName(this.translator.translateGermanToEnglish(germanCountry), name);
    }

    @Override
    public int countInstitutionsByCountryAndName(String country, String name) {
        return super.countInstitutionsByCountryAndName(this.translator.translateGermanToEnglish(country), name);
    }

    @Override
    public List<String> findCountriesByName(String name) {
        return this.germanCountries.stream().filter(country -> country.contains(name)).collect(Collectors.toList());
    }

    @Override
    public int countCountriesByName(String name) {
        return (int)this.germanCountries.stream().filter(country -> country.contains(name)).count();
    }

    @Override
    public void setGermanCountries() {
        this.germanCountries = new ArrayList<String>();
        for (String englishCountry : this.countries) {
            this.germanCountries.add(this.translator.translateEnglishToGerman(englishCountry));
        }
    }
}

