package org.infinitenature.herbariorum.helper;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translator
{
   private static final String BUNDLE_NAME = "translator_resources";

   private Map<String, String> englishToGerman;
   private Map<String, String> germanToEnglish;
   private Map<Country, String> enumToGerman;
   private Map<Country, String> enumToEnglish;

   public Translator()
   {
      ResourceBundle germanBundle = ResourceBundle
            .getBundle(BUNDLE_NAME, Locale.GERMANY, new UTF8Control());
      ResourceBundle englishBundle = ResourceBundle
            .getBundle(BUNDLE_NAME, Locale.UK, new UTF8Control());
      englishToGerman = new HashMap<>();
      germanToEnglish = new HashMap<>();
      enumToGerman = new EnumMap<>(Country.class);
      enumToEnglish = new EnumMap<>(Country.class);
      for (Country country : Country.values())
      {
         String english = getString(country.name(), englishBundle);
         String german = getString(country.name(), germanBundle);
         englishToGerman.put(english, german);
         germanToEnglish.put(german, english);
         enumToGerman.put(country, german);
         enumToEnglish.put(country, english);
      }
   }

   public String translateEnglishToGerman(String english)
   {
      if (englishToGerman.containsKey(english))
      {
         return englishToGerman.get(english);
      }
      return english;
   }

   public String translateGermanToEnglish(String german)
   {
      if (germanToEnglish.containsKey(german))
      {
         return germanToEnglish.get(german);
      }
      return german;
   }

   private String getString(String key, ResourceBundle bundle)
   {
      try
      {
         return bundle.getString(key);

      } catch (MissingResourceException e)
      {
         return key;
      }
   }

   public Collection<String> getAllCountriesInGerman()
   {
      return englishToGerman.values();
   }

   public Collection<String> getAllCountriesInEnglish()
   {
      return germanToEnglish.values();
   }

   public String getCountryInGerman(Country country)
   {
      return enumToGerman.get(country);
   }

   public String getCountryInEnglish(Country country)
   {
      return enumToEnglish.get(country);
   }
}
