package org.infinitenature.herbariorum.helper;

import org.infinitenature.herbariorum.entities.Institution;

import java.util.Comparator;

public class InstitutionComparator implements Comparator<Institution>
{
   @Override
   public int compare(Institution o1, Institution o2)
   {
      return  Comparator.comparing((Institution i) -> i.getOrganization())
            .thenComparing((Institution i) -> i.getAddress().getPostalCountry())
            .thenComparing((Institution i) -> i.getAddress().getPostalCity()).compare(o1, o2);
   }
}
