package org.infinitenature.herbariorum.entities;

import javax.ws.rs.BeanParam;
import javax.ws.rs.QueryParam;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;


public class Institution
{
   @QueryParam("irn")
   private int irn;
   @QueryParam("organization")
   private String organization;
   @QueryParam("code")
   private String code;
   @QueryParam("division")
   private String division;
   @QueryParam("department")
   private String department;
   @QueryParam("specimenTotal")
   private int specimenTotal;
   @BeanParam
   private Address address;
   @BeanParam
   private Contact contact;
   @BeanParam
   private Location location;
   @QueryParam("dateModified")
   private LocalDate dateModified;


   public int getIrn()
   {
      return irn;
   }

   public void setIrn(int irn)
   {
      this.irn = irn;
   }

   public String getOrganization()
   {
      return organization;
   }

   public void setOrganization(String organization)
   {
      if(organization != null)
      {
         this.organization = organization.trim();
      }
      else
      {
         this.organization = organization;
      }
   }

   public String getCode()
   {
      return code;
   }

   public void setCode(String code)
   {
      this.code = code;
   }

   public String getDivision()
   {
      return division;
   }

   public void setDivision(String division)
   {
      this.division = division;
   }

   public String getDepartment()
   {
      return department;
   }

   public void setDepartment(String department)
   {
      this.department = department;
   }

   public int getSpecimenTotal()
   {
      return specimenTotal;
   }

   public void setSpecimenTotal(int specimenTotal)
   {
      this.specimenTotal = specimenTotal;
   }

   public Address getAddress()
   {
      return address;
   }

   public void setAddress(Address address)
   {
      this.address = address;
   }

   public Contact getContact()
   {
      return contact;
   }

   public void setContact(Contact contact)
   {
      this.contact = contact;
   }

   public Location getLocation()
   {
      return location;
   }

   public void setLocation(Location location)
   {
      this.location = location;
   }

   public LocalDate getDateModified()
   {
      return dateModified;
   }

   public void setDateModified(String dateModified)
   {
      DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
      this.dateModified = LocalDate.parse(dateModified, dateTimeFormatter);
   }

   @Override
   public String toString()
   {
      if(getOrganization() == null)
      {
         return "";
      }
      if(getAddress() == null)
      {
         return getOrganization();
      }
      return getOrganization() + ", " + getAddress().getPostalCity();
   }
}
