package org.infinitenature.herbariorum.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.infinitenature.herbariorum.entities.Institution;

public class HerbariorumMemoryClient implements Client
{
   private Herbariorum herbariorum;
   private List<Institution> institutions;
   protected Collection<String> countries;

   public HerbariorumMemoryClient()
   {
      herbariorum = new Herbariorum("http://sweetgum.nybg.org");
      institutions = herbariorum.institutions().findAll().getInstitutions();
      countries = herbariorum.countries().findCountries().getCountries();
   }

   /**
    * Parameter country is mandatory, no country returns no institutions.
    * Parameter name is a filter, empty filter returns all institutions in the country.
    * returns a list of institutions.
    *
    * @param country
    * @param name
    * @return
    */
   @Override
   public List<Institution> findInstitutionsByCountryAndName(String country,
         String name)
   {
      if (country == null)
      {
         return Collections.emptyList();
      }

      return institutions.stream().filter(
            institution -> institution.getAddress().getPostalCountry()
                  .equalsIgnoreCase(country))
            .filter(institution -> institution.getOrganization().contains(name))
            .collect(Collectors.toList());
   }

   /**
    * Parameter country is mandatory, no country no institutions.
    * Parameter name is a filter, empty filter returns the number of all institutions in the country.
    * returns the number of institutions
    *
    * @param country
    * @param name
    * @return
    */
   @Override
   public int countInstitutionsByCountryAndName(String country, String name)
   {
      if (country == null)
      {
         return 0;
      }

      return (int) institutions.stream().filter(
            institution -> institution.getAddress().getPostalCountry()
                  .equalsIgnoreCase(country))
            .filter(institution -> institution.getOrganization().contains(name))
            .count();
   }

   /**
    * Parameter name is a filter, empty filter returns all countries.
    *
    * @param name
    * @return
    */
   @Override
   public List<String> findCountriesByName(String name)
   {
      return countries.stream()
            .filter(country -> country.contains(name))
            .collect(Collectors.toList());
   }

   /**
    * Parameter name is a filter, empty filter returns number of all countries.
    *
    * @param name
    * @return
    */
   @Override
   public int countCountriesByName(String name)
   {
      return (int) countries.stream()
            .filter(country -> country.contains(name)).count();
   }

   @Override
   public void setInstitutions(List<Institution> institutions)
   {
      this.institutions = institutions;
   }

   @Override
   public void setCountries(Collection<String> countries)
   {
      this.countries = countries;
   }

   @Override
   public void setGermanCountries()
   {

   }

   @Override
   public void setHerbariorum(Herbariorum herbariorum)
   {

      this.herbariorum = herbariorum;
   }

}
