package org.infinitenature.herbariorum.client;

import org.infinitenature.herbariorum.entities.Institution;
import org.infinitenature.herbariorum.helper.Translator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class HerbariorumGermanClient extends HerbariorumMemoryClient
{
   private Translator translator;
   private Collection<String> germanCountries;

   public HerbariorumGermanClient()
   {
      super();
      translator = new Translator();
      germanCountries = new ArrayList<>();
      for (String englishCountry : countries)
      {
         germanCountries
               .add(translator.translateEnglishToGerman(englishCountry));
      }
   }

   /**
    * Parameter country is mandatory, no country returns no institutions.
    * Parameter name is a filter, empty filter returns all institutions in the country.
    * returns a list of institutions.
    *
    * @param germanCountry
    * @param name
    * @return
    */
   @Override
   public List<Institution> findInstitutionsByCountryAndName(
         String germanCountry, String name)
   {
      return super.findInstitutionsByCountryAndName(
            translator.translateGermanToEnglish(germanCountry), name);
   }

   /**
    * Parameter country is mandatory, no country no institutions.
    * Parameter name is a filter, empty filter returns the number of all institutions in the country.
    * returns the number of institutions
    *
    * @param country
    * @param name
    * @return
    */
   @Override
   public int countInstitutionsByCountryAndName(String country, String name)
   {
      return super.countInstitutionsByCountryAndName(
            translator.translateGermanToEnglish(country), name);
   }

   /**
    * Parameter name is a filter, empty filter returns all countries.
    *
    * @param name
    * @return
    */
   @Override
   public List<String> findCountriesByName(String name)
   {
      return germanCountries.stream().filter(country -> country.contains(name))
            .collect(Collectors.toList());
   }

   /**
    * Parameter name is a filter, empty filter returns number of all countries.
    *
    * @param name
    * @return
    */
   @Override
   public int countCountriesByName(String name)
   {
      return (int) germanCountries.stream()
            .filter(country -> country.contains(name)).count();
   }

   public void setGermanCountries()
   {
      germanCountries = new ArrayList<>();
      for (String englishCountry : countries)
      {
         germanCountries
               .add(translator.translateEnglishToGerman(englishCountry));
      }
   }
}
