/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.rhq;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.server.rhq.MetricsRemappingComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;

public class IspnCacheComponent
extends MetricsRemappingComponent<IspnCacheComponent>
implements ConfigurationFacet {
    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Set<MeasurementScheduleRequest> requests = metrics;
        HashSet<MeasurementScheduleRequest> todo = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest req : requests) {
            if (req.getName().equals("__flavor")) {
                String flavor = this.getCacheFlavorFromPath();
                MeasurementDataTrait trait = new MeasurementDataTrait(req, flavor);
                report.addData(trait);
                continue;
            }
            todo.add(req);
        }
        super.getValues(report, todo);
    }

    private String getCacheFlavorFromPath() {
        String flavor = this.getPath().substring(this.getPath().lastIndexOf(",") + 1);
        flavor = flavor.substring(0, flavor.indexOf("="));
        return flavor;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = super.loadResourceConfiguration();
        String f = this.getCacheFlavorFromPath();
        PropertySimple flavor = new PropertySimple("_flavor", (Object)f);
        config.put((Property)flavor);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.getConfiguration().remove("_flavor");
        super.updateResourceConfiguration(report);
    }
}

