/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.JChannel;

public enum ChannelMetric implements Metric<JChannel>
{
    ADDRESS("address", ModelType.STRING){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getAddressAsString());
        }
    }
    ,
    ADDRESS_AS_UUID("address-as-uuid", ModelType.STRING){

        public ModelNode execute(JChannel channel) {
            String addressAsUUID = channel.getAddressAsUUID();
            return new ModelNode(addressAsUUID == null ? "n/a" : addressAsUUID);
        }
    }
    ,
    DISCARD_OWN_MESSAGES("discard-own-messages", ModelType.BOOLEAN){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getDiscardOwnMessages());
        }
    }
    ,
    NUM_TASKS_IN_TIMER("num-tasks-in-timer", ModelType.INT){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getProtocolStack().getTransport().getNumTimerTasks());
        }
    }
    ,
    NUM_TIMER_THREADS("num-timer-threads", ModelType.INT){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getProtocolStack().getTransport().getTimerThreads());
        }
    }
    ,
    RECEIVED_BYTES("received-bytes", ModelType.LONG){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getReceivedBytes());
        }
    }
    ,
    RECEIVED_MESSAGES("received-messages", ModelType.LONG){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getReceivedMessages());
        }
    }
    ,
    SENT_BYTES("sent-bytes", ModelType.LONG){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getSentBytes());
        }
    }
    ,
    SENT_MESSAGES("sent-messages", ModelType.LONG){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getSentMessages());
        }
    }
    ,
    STATE("state", ModelType.STRING){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getState());
        }
    }
    ,
    STATS_ENABLED("stats-enabled", ModelType.BOOLEAN){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.stats());
        }
    }
    ,
    VERSION("version", ModelType.STRING){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(JChannel.getVersion());
        }
    }
    ,
    VIEW("view", ModelType.STRING){

        public ModelNode execute(JChannel channel) {
            return new ModelNode(channel.getViewAsString());
        }
    };

    private final AttributeDefinition definition;

    private ChannelMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }
}

