/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.query.SearchManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.SecurityActions;
import org.jboss.as.clustering.infinispan.subsystem.SharedCacheResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class CacheCommands
implements OperationStepHandler {
    CacheCommands() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ListIterator iterator = address.iterator();
        PathElement element = (PathElement)iterator.next();
        while (!element.getValue().equals("datagrid-infinispan")) {
            element = (PathElement)iterator.next();
        }
        String cacheContainerName = ((PathElement)iterator.next()).getValue();
        String cacheName = ((PathElement)iterator.next()).getValue();
        if (context.isNormalServer()) {
            ModelNode operationResult;
            ServiceController controller = context.getServiceRegistry(false).getService(CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName));
            Cache cache = (Cache)controller.getValue();
            try {
                operationResult = this.invokeCommand(cache, operation, context);
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()), (Throwable)e);
            }
            if (operationResult != null) {
                context.getResult().set(operationResult);
            }
        }
    }

    protected abstract ModelNode invokeCommand(Cache<?, ?> var1, ModelNode var2, OperationContext var3) throws Exception;

    private static ModelNode toOperationResult(String s) {
        ModelNode result = new ModelNode();
        result.add(s);
        return result;
    }

    private static String prettyPrintMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static class CacheRebalanceCommand
    extends CacheCommands {
        public static final CacheRebalanceCommand INSTANCE = new CacheRebalanceCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext operationContext) throws Exception {
            boolean value = SharedCacheResource.BOOL_VALUE.resolveModelAttribute(operationContext, operation).asBoolean();
            LocalTopologyManager topologyManager = (LocalTopologyManager)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(LocalTopologyManager.class);
            if (topologyManager != null) {
                topologyManager.setCacheRebalancingEnabled(cache.getName(), value);
            }
            return null;
        }
    }

    public static class MassReindexCommand
    extends CacheCommands {
        public static final MassReindexCommand INSTANCE = new MassReindexCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SearchManager searchManager = SecurityActions.getSearchManager(cache.getAdvancedCache());
            if (searchManager != null) {
                searchManager.getMassIndexer().start();
            }
            return null;
        }
    }

    public static class BackupClearPushStatusCommand
    extends CacheCommands {
        public static final BackupClearPushStatusCommand INSTANCE = new BackupClearPushStatusCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            xsiteAdminOperations.clearPushStateStatus();
            return null;
        }
    }

    public static class BackupGetSendingSiteCommand
    extends CacheCommands {
        public static final BackupGetSendingSiteCommand INSTANCE = new BackupGetSendingSiteCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.getSendingSiteName());
        }
    }

    public static class BackupPushStateStatusCommand
    extends CacheCommands {
        public static final BackupPushStateStatusCommand INSTANCE = new BackupPushStateStatusCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(CacheCommands.prettyPrintMap(xsiteAdminOperations.getPushStateStatus()));
        }
    }

    public static class BackupCancelReceiveStateCommand
    extends CacheCommands {
        public static final BackupCancelReceiveStateCommand INSTANCE = new BackupCancelReceiveStateCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.cancelReceiveState(site));
        }
    }

    public static class BackupCancelPushStateCommand
    extends CacheCommands {
        public static final BackupCancelPushStateCommand INSTANCE = new BackupCancelPushStateCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.cancelPushState(site));
        }
    }

    public static class BackupPushStateCommand
    extends CacheCommands {
        public static final BackupPushStateCommand INSTANCE = new BackupPushStateCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.pushState(site));
        }
    }

    public static class DisconnectSourceCommand
    extends CacheCommands {
        public static final DisconnectSourceCommand INSTANCE = new DisconnectSourceCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) throws Exception {
            ComponentRegistry registry = SecurityActions.getComponentRegistry(cache.getAdvancedCache());
            RollingUpgradeManager manager = (RollingUpgradeManager)registry.getComponent(RollingUpgradeManager.class);
            if (manager != null) {
                manager.disconnectSource(operation.require("migrator-name").asString());
            }
            return null;
        }
    }

    public static class SynchronizeDataCommand
    extends CacheCommands {
        public static final SynchronizeDataCommand INSTANCE = new SynchronizeDataCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) throws Exception {
            ComponentRegistry registry = SecurityActions.getComponentRegistry(cache.getAdvancedCache());
            RollingUpgradeManager manager = (RollingUpgradeManager)registry.getComponent(RollingUpgradeManager.class);
            if (manager != null) {
                int readBatch = CacheResource.READ_BATCH.resolveModelAttribute(context, operation).asInt();
                int writeThreads = CacheResource.WRITE_THREADS.resolveModelAttribute(context, operation).asInt();
                manager.synchronizeData(operation.require("migrator-name").asString(), readBatch, writeThreads);
            }
            return null;
        }
    }

    public static class BackupSiteStatusCommand
    extends CacheCommands {
        public static final BackupSiteStatusCommand INSTANCE = new BackupSiteStatusCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.siteStatus(site));
        }
    }

    public static class BackupTakeSiteOfflineCommand
    extends CacheCommands {
        public static final BackupTakeSiteOfflineCommand INSTANCE = new BackupTakeSiteOfflineCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.takeSiteOffline(site));
        }
    }

    public static class BackupBringSiteOnlineCommand
    extends CacheCommands {
        public static final BackupBringSiteOnlineCommand INSTANCE = new BackupBringSiteOnlineCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.bringSiteOnline(site));
        }
    }

    public static class TransactionForgetCommand
    extends CacheCommands {
        public static final TransactionForgetCommand INSTANCE = new TransactionForgetCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            long internalId = operation.require("internal-id").asLong();
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.forget(internalId));
        }
    }

    public static class TransactionForceRollbackCommand
    extends CacheCommands {
        public static final TransactionForceRollbackCommand INSTANCE = new TransactionForceRollbackCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            long internalId = operation.require("internal-id").asLong();
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.forceRollback(internalId));
        }
    }

    public static class TransactionForceCommitCommand
    extends CacheCommands {
        public static final TransactionForceCommitCommand INSTANCE = new TransactionForceCommitCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            long internalId = operation.require("internal-id").asLong();
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.forceCommit(internalId));
        }
    }

    public static class TransactionListInDoubtCommand
    extends CacheCommands {
        public static final TransactionListInDoubtCommand INSTANCE = new TransactionListInDoubtCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.showInDoubtTransactions());
        }
    }

    public static class ResetCacheLoaderStatisticsCommand
    extends CacheCommands {
        public static final ResetCacheLoaderStatisticsCommand INSTANCE = new ResetCacheLoaderStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.resetStatistics(cache.getAdvancedCache(), CacheWriterInterceptor.class);
            return null;
        }
    }

    public static class ResetRpcManagerStatisticsCommand
    extends CacheCommands {
        public static final ResetRpcManagerStatisticsCommand INSTANCE = new ResetRpcManagerStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            RpcManagerImpl rpcManager = (RpcManagerImpl)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(RpcManager.class);
            if (rpcManager != null) {
                rpcManager.resetStatistics();
            }
            return null;
        }
    }

    public static class ResetPassivationStatisticsCommand
    extends CacheCommands {
        public static final ResetPassivationStatisticsCommand INSTANCE = new ResetPassivationStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.resetStatistics(cache.getAdvancedCache(), PassivationManager.class);
            return null;
        }
    }

    public static class ResetActivationStatisticsCommand
    extends CacheCommands {
        public static final ResetActivationStatisticsCommand INSTANCE = new ResetActivationStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.resetStatistics(cache.getAdvancedCache(), CacheLoaderInterceptor.class);
            return null;
        }
    }

    public static class ResetInvalidationStatisticsCommand
    extends CacheCommands {
        public static final ResetInvalidationStatisticsCommand INSTANCE = new ResetInvalidationStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.resetStatistics(cache.getAdvancedCache(), InvalidationInterceptor.class);
            return null;
        }
    }

    public static class ResetTxStatisticsCommand
    extends CacheCommands {
        public static final ResetTxStatisticsCommand INSTANCE = new ResetTxStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.resetStatistics(cache.getAdvancedCache(), TxInterceptor.class);
            return null;
        }
    }

    public static class ShudownCacheCommand
    extends CacheCommands {
        public static final ShudownCacheCommand INSTANCE = new ShudownCacheCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.shutdownCache(cache.getAdvancedCache());
            return null;
        }
    }

    public static class StopCacheCommand
    extends CacheCommands {
        public static final StopCacheCommand INSTANCE = new StopCacheCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.stopCache(cache.getAdvancedCache());
            return null;
        }
    }

    public static class StartCacheCommand
    extends CacheCommands {
        public static final StartCacheCommand INSTANCE = new StartCacheCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.startCache(cache.getAdvancedCache());
            return null;
        }
    }

    public static class FlushCacheCommand
    extends CacheCommands {
        public static final FlushCacheCommand INSTANCE = new FlushCacheCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.flushCache(cache.getAdvancedCache());
            return null;
        }
    }

    public static class ClearCacheCommand
    extends CacheCommands {
        public static final ClearCacheCommand INSTANCE = new ClearCacheCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.clearCache(cache.getAdvancedCache());
            return null;
        }
    }

    public static class ResetCacheStatisticsCommand
    extends CacheCommands {
        public static final ResetCacheStatisticsCommand INSTANCE = new ResetCacheStatisticsCommand();

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation, OperationContext context) {
            SecurityActions.resetStatistics(cache.getAdvancedCache(), CacheMgmtInterceptor.class);
            return null;
        }
    }
}

