/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class ClusteredCacheConfigurationAdd
extends CacheConfigurationAdd {
    ClusteredCacheConfigurationAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        for (AttributeDefinition attribute : ClusteredCacheConfigurationResource.ATTRIBUTES) {
            attribute.validateAndSet(fromModel, toModel);
        }
    }

    @Override
    void processModelNode(OperationContext context, String containerName, String cacheName, ModelNode cache, ConfigurationBuilder builder, List<CacheConfigurationAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cacheName, cache, builder, dependencies);
        ModelNode modeModel = ClusteredCacheConfigurationResource.MODE.resolveModelAttribute(context, cache);
        CacheMode cacheMode = modeModel.isDefined() ? Mode.valueOf(modeModel.asString()).apply(this.mode) : this.mode;
        builder.clustering().cacheMode(cacheMode);
        long remoteTimeout = ClusteredCacheConfigurationResource.REMOTE_TIMEOUT.resolveModelAttribute(context, cache).asLong();
        if (cacheMode.isSynchronous()) {
            builder.clustering().remoteTimeout(remoteTimeout);
        }
    }
}

