/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class GetProtoSchemaErrorsHandler
extends AbstractRuntimeOnlyHandler {
    public static final GetProtoSchemaErrorsHandler INSTANCE = new GetProtoSchemaErrorsHandler();

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        EmbeddedCacheManager cacheManager;
        ProtobufMetadataManager protoManager;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        if (controller != null && (protoManager = (ProtobufMetadataManager)(cacheManager = (EmbeddedCacheManager)controller.getValue()).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class)) != null) {
            try {
                ModelNode name = operation.require(CacheContainerResource.PROTO_NAME.getName());
                this.validateParameters(name);
                String fileErrors = protoManager.getFileErrors(name.asString());
                ModelNode result = new ModelNode();
                if (fileErrors != null) {
                    result.set(fileErrors);
                }
                context.getResult().set(result);
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
            }
        }
    }

    private void validateParameters(ModelNode name) {
        if (name.getType() != ModelType.STRING) {
            throw InfinispanMessages.MESSAGES.invalidParameterType(CacheContainerResource.PROTO_NAME.getName(), ModelType.STRING.toString());
        }
    }
}

