/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationsResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.PathAddressUtils;
import org.jboss.as.clustering.infinispan.subsystem.RestartableServiceHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RestartCacheResourceAdd
extends RestartParentResourceAddHandler {
    private final AttributeDefinition[] attributes;
    private final RestartableServiceHandler parentServiceHandler;
    private final CacheServiceName serviceNameResolver;

    RestartCacheResourceAdd(String parentKeyName, RestartableServiceHandler parentServiceHandler, CacheServiceName serviceNameResolver, AttributeDefinition[] attributes) {
        super(parentKeyName);
        this.attributes = attributes;
        this.parentServiceHandler = parentServiceHandler;
        this.serviceNameResolver = serviceNameResolver;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void recreateParentService(OperationContext context, PathAddress resourceAddress, ModelNode resourceModel) throws OperationFailedException {
        int containerPosition = PathAddressUtils.indexOfKey(resourceAddress, CacheContainerResource.CONTAINER_PATH.getKey());
        PathAddress containerAddress = resourceAddress.subAddress(0, containerPosition + 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        ModelNode operation = Util.createAddOperation((PathAddress)resourceAddress);
        this.parentServiceHandler.installRuntimeServices(context, operation, containerModel, resourceModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        int containerPosition = PathAddressUtils.indexOfKey(parentAddress, CacheContainerResource.CONTAINER_PATH.getKey());
        String containerName = parentAddress.getElement(containerPosition).getValue();
        int resourceOffset = containerPosition + 1;
        if (parentAddress.getElement(resourceOffset).equals(CacheContainerConfigurationsResource.PATH)) {
            ++resourceOffset;
        }
        String resourceName = parentAddress.getElement(resourceOffset).getValue();
        return this.serviceNameResolver.getServiceName(containerName, resourceName);
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        super.removeServices(context, parentService, parentModel);
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return true;
    }
}

