/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.infinispan.task;

import java.lang.reflect.Constructor;
import java.util.List;
import org.infinispan.server.infinispan.task.ServerTaskRegistry;
import org.infinispan.server.infinispan.task.ServerTaskRegistryService;
import org.infinispan.tasks.ServerTask;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerTaskProcessor
implements DeploymentUnitProcessor {
    public static final String EXTERNAL_TASK = "ExternalTask";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            this.addServices(phaseContext, servicesAttachment, module);
        }
    }

    private void addServices(DeploymentPhaseContext ctx, ServicesAttachment servicesAttachment, Module module) {
        List implementationNames = servicesAttachment.getServiceImplementations(ServerTask.class.getName());
        ModuleClassLoader classLoader = module.getClassLoader();
        for (String serviceClassName : implementationNames) {
            try {
                Class<ServerTask> clazz = classLoader.loadClass(serviceClassName).asSubclass(ServerTask.class);
                Constructor<ServerTask> ctor = clazz.getConstructor(new Class[0]);
                ServerTask instance = ctor.newInstance(new Object[0]);
                this.installService(ctx, serviceClassName, instance);
            }
            catch (Exception e) {
                throw InfinispanMessages.MESSAGES.unableToInstantiateClass(serviceClassName);
            }
        }
    }

    public final void installService(DeploymentPhaseContext ctx, String implementationClassName, ServerTask instance) {
        TaskManagerService service = new TaskManagerService(implementationClassName, instance);
        ServiceName extensionServiceName = ServiceName.JBOSS.append(new String[]{EXTERNAL_TASK, implementationClassName.replaceAll("\\.", "_")});
        InfinispanLogger.ROOT_LOGGER.installDeployedCacheStore(implementationClassName);
        ServiceBuilder serviceBuilder = ctx.getServiceTarget().addService(extensionServiceName, (Service)service);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.addDependency(ServerTaskRegistryService.SERVICE_NAME, ServerTaskRegistry.class, service.getDeployedTaskManager());
        serviceBuilder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected static class TaskManagerService
    implements Service<ServerTask> {
        protected final ServerTask extension;
        protected final String className;
        protected InjectedValue<ServerTaskRegistry> deployedTaskRegistry = new InjectedValue();

        protected TaskManagerService(String className, ServerTask extension) {
            this.extension = extension;
            this.className = className;
        }

        public void start(StartContext context) {
            InfinispanLogger.ROOT_LOGGER.deployedStoreStarted(this.className);
            ((ServerTaskRegistry)this.deployedTaskRegistry.getValue()).addDeployedTask(this.extension);
        }

        public void stop(StopContext context) {
            InfinispanLogger.ROOT_LOGGER.deployedStoreStopped(this.className);
            ((ServerTaskRegistry)this.deployedTaskRegistry.getValue()).removeDeployedTask(this.extension.getName());
        }

        public InjectedValue<ServerTaskRegistry> getDeployedTaskManager() {
            return this.deployedTaskRegistry;
        }

        public ServerTask getValue() {
            return this.extension;
        }
    }
}

