/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.controller.ModelVersion;

public enum Namespace {
    UNKNOWN("jboss:domain:infinispan", 0, 0),
    INFINISPAN_SERVER_6_0("infinispan:server:core", 6, 0),
    INFINISPAN_SERVER_7_0("infinispan:server:core", 7, 0),
    INFINISPAN_SERVER_7_1("infinispan:server:core", 7, 1),
    INFINISPAN_SERVER_7_2("infinispan:server:core", 7, 2),
    INFINISPAN_SERVER_8_0("infinispan:server:core", 8, 0);

    private static final String URN_PATTERN = "urn:%s:%d.%d";
    public static final Namespace CURRENT;
    private final int major;
    private final int minor;
    private final String domain;
    private final ModelVersion version;

    private Namespace(String domain, int major, int minor) {
        this.domain = domain;
        this.major = major;
        this.minor = minor;
        this.version = ModelVersion.create((int)major, (int)minor);
    }

    public String getUri() {
        return String.format(URN_PATTERN, this.domain, this.major, this.minor);
    }

    public ModelVersion getVersion() {
        return this.version;
    }

    public String format(String format) {
        return String.format(format, this.major, this.minor);
    }

    public boolean since(Namespace schema) {
        return this.major > schema.major || this.major == schema.major && this.minor >= schema.minor;
    }

    static {
        CURRENT = INFINISPAN_SERVER_8_0;
    }
}

