/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAdd;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CacheContainerRemove
extends AbstractRemoveStepHandler {
    public static final CacheContainerRemove INSTANCE = new CacheContainerRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String containerName = address.getLastElement().getValue();
        this.removeExistingCacheServices(context, model, containerName);
        CacheContainerAdd.INSTANCE.removeRuntimeServices(context, operation, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String containerName = address.getLastElement().getValue();
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        CacheContainerAdd.INSTANCE.installRuntimeServices(context, operation, model, verificationHandler);
        this.reinstallExistingCacheServices(context, model, containerName, verificationHandler);
    }

    private void reinstallExistingCacheServices(OperationContext context, ModelNode containerModel, String containerName, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        List<Property> list;
        List<Property> list2;
        List<Property> invalidationCacheList;
        List<Property> localCacheList = this.getCachesFromParentModel("local-cache", containerModel);
        if (localCacheList != null) {
            for (Property property : localCacheList) {
                String string = property.getName();
                ModelNode localCacheModel = property.getValue();
                ModelNode localCacheAddOp = this.createCacheAddOperation("local-cache", containerName, string);
                LocalCacheAdd.INSTANCE.installRuntimeServices(context, localCacheAddOp, containerModel, localCacheModel, verificationHandler);
            }
        }
        if ((invalidationCacheList = this.getCachesFromParentModel("invalidation-cache", containerModel)) != null) {
            for (Property property : invalidationCacheList) {
                String invCacheName = property.getName();
                ModelNode invCacheModel = property.getValue();
                ModelNode invCacheAddOp = this.createCacheAddOperation("invalidation-cache", containerName, invCacheName);
                InvalidationCacheAdd.INSTANCE.installRuntimeServices(context, invCacheAddOp, containerModel, invCacheModel, verificationHandler);
            }
        }
        if ((list2 = this.getCachesFromParentModel("replicated-cache", containerModel)) != null) {
            for (Property replCache : list2) {
                String replCacheName = replCache.getName();
                ModelNode replCacheModel = replCache.getValue();
                ModelNode replCacheAddOp = this.createCacheAddOperation("replicated-cache", containerName, replCacheName);
                ReplicatedCacheAdd.INSTANCE.installRuntimeServices(context, replCacheAddOp, containerModel, replCacheModel, verificationHandler);
            }
        }
        if ((list = this.getCachesFromParentModel("distributed-cache", containerModel)) != null) {
            for (Property distCache : list) {
                String distCacheName = distCache.getName();
                ModelNode distCacheModel = distCache.getValue();
                ModelNode distCacheAddOp = this.createCacheAddOperation("distributed-cache", containerName, distCacheName);
                DistributedCacheAdd.INSTANCE.installRuntimeServices(context, distCacheAddOp, containerModel, distCacheModel, verificationHandler);
            }
        }
    }

    private void removeExistingCacheServices(OperationContext context, ModelNode containerModel, String containerName) throws OperationFailedException {
        List<Property> list;
        List<Property> list2;
        List<Property> invalidationCacheList;
        List<Property> localCacheList = this.getCachesFromParentModel("local-cache", containerModel);
        if (localCacheList != null) {
            for (Property property : localCacheList) {
                String string = property.getName();
                ModelNode localCacheModel = property.getValue();
                ModelNode localCacheRemoveOp = this.createCacheRemoveOperation("local-cache", containerName, string);
                LocalCacheAdd.INSTANCE.removeRuntimeServices(context, localCacheRemoveOp, localCacheModel);
            }
        }
        if ((invalidationCacheList = this.getCachesFromParentModel("invalidation-cache", containerModel)) != null) {
            for (Property property : invalidationCacheList) {
                String invCacheName = property.getName();
                ModelNode invCacheModel = property.getValue();
                ModelNode invCacheRemoveOp = this.createCacheRemoveOperation("invalidation-cache", containerName, invCacheName);
                InvalidationCacheAdd.INSTANCE.removeRuntimeServices(context, invCacheRemoveOp, invCacheModel);
            }
        }
        if ((list2 = this.getCachesFromParentModel("replicated-cache", containerModel)) != null) {
            for (Property replCache : list2) {
                String replCacheName = replCache.getName();
                ModelNode replCacheModel = replCache.getValue();
                ModelNode replCacheRemoveOp = this.createCacheRemoveOperation("replicated-cache", containerName, replCacheName);
                ReplicatedCacheAdd.INSTANCE.removeRuntimeServices(context, replCacheRemoveOp, replCacheModel);
            }
        }
        if ((list = this.getCachesFromParentModel("distributed-cache", containerModel)) != null) {
            for (Property distCache : list) {
                String distCacheName = distCache.getName();
                ModelNode distCacheModel = distCache.getValue();
                ModelNode distCacheRemoveOp = this.createCacheRemoveOperation("distributed-cache", containerName, distCacheName);
                DistributedCacheAdd.INSTANCE.removeRuntimeServices(context, distCacheRemoveOp, distCacheModel);
            }
        }
    }

    private List<Property> getCachesFromParentModel(String cacheType, ModelNode model) {
        List cacheList = null;
        ModelNode caches = model.get(cacheType);
        if (caches.isDefined() && caches.getType() == ModelType.OBJECT) {
            cacheList = caches.asPropertyList();
            return cacheList;
        }
        return null;
    }

    private ModelNode createCacheRemoveOperation(String cacheType, String containerName, String cacheName) {
        PathAddress cacheAddr = this.getCacheAddress(containerName, cacheName, cacheType);
        ModelNode removeOp = new ModelNode();
        removeOp.get("operation").set("remove");
        removeOp.get("address").set(cacheAddr.toModelNode());
        return removeOp;
    }

    private ModelNode createCacheAddOperation(String cacheType, String containerName, String cacheName) {
        PathAddress cacheAddr = this.getCacheAddress(containerName, cacheName, cacheType);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(cacheAddr.toModelNode());
        return addOp;
    }

    private PathAddress getCacheAddress(String containerName, String cacheName, String cacheType) {
        PathAddress cacheAddr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"infinispan"), PathElement.pathElement((String)"cache-container", (String)containerName), PathElement.pathElement((String)cacheType, (String)cacheName)});
        return cacheAddr;
    }
}

