/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.SecurityActions;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class AbstractCacheConfigurationService
implements Service<Configuration> {
    private final String name;
    private volatile Configuration config;
    private static final Logger log = Logger.getLogger((String)AbstractCacheConfigurationService.class.getPackage().getName());

    public static ServiceName getServiceName(String container, String cache) {
        return CacheService.getServiceName(container, cache).append(new String[]{"config"});
    }

    protected AbstractCacheConfigurationService(String name) {
        this.name = name;
    }

    public Configuration getValue() {
        return this.config;
    }

    protected abstract ConfigurationBuilder getConfigurationBuilder();

    protected abstract EmbeddedCacheManager getCacheContainer();

    public void start(StartContext context) throws StartException {
        this.config = this.getConfigurationBuilder().build();
        EmbeddedCacheManager container = this.getCacheContainer();
        CacheMode mode = this.config.clustering().cacheMode();
        if (mode.isClustered() && container.getTransport() == null) {
            throw InfinispanMessages.MESSAGES.transportRequired(mode, this.name, container.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName());
        }
        SecurityActions.defineContainerConfiguration(container, this.name, this.config);
        log.debugf("%s cache configuration started", (Object)this.name);
    }

    public void stop(StopContext context) {
        this.config = null;
        SecurityActions.undefineContainerConfiguration(this.getCacheContainer(), this.name);
        log.debugf("%s cache configuration stopped", (Object)this.name);
    }
}

