/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class CacheConfigurationService
extends AbstractCacheConfigurationService {
    private final ConfigurationBuilder builder;
    private final ModuleIdentifier moduleId;
    private final Dependencies dependencies;

    public CacheConfigurationService(String name, ConfigurationBuilder builder, ModuleIdentifier moduleId, Dependencies dependencies) {
        super(name);
        this.builder = builder;
        this.moduleId = moduleId;
        this.dependencies = dependencies;
    }

    @Override
    protected EmbeddedCacheManager getCacheContainer() {
        return this.dependencies.getCacheContainer();
    }

    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        TransactionSynchronizationRegistry tsr;
        this.builder.jmxStatistics().enabled(this.dependencies.getCacheContainer().getCacheManagerConfiguration().globalJmxStatistics().enabled());
        TransactionManager tm = this.dependencies.getTransactionManager();
        if (tm != null) {
            this.builder.transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(tm));
        }
        if ((tsr = this.dependencies.getTransactionSynchronizationRegistry()) != null) {
            this.builder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(tsr));
        }
        return this.builder;
    }

    static interface Dependencies {
        public ModuleLoader getModuleLoader();

        public EmbeddedCacheManager getCacheContainer();

        public TransactionManager getTransactionManager();

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry();
    }
}

