/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.infinispan.SecurityActions;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class CacheContainerMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheContainerMetricsHandler INSTANCE = new CacheContainerMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getLastElement().getValue();
        String attrName = operation.require("name").asString();
        ServiceController controller = context.getServiceRegistry(false).getService(EmbeddedCacheManagerService.getServiceName(cacheContainerName));
        DefaultEmbeddedCacheManager cacheManager = (DefaultEmbeddedCacheManager)((Object)controller.getValue());
        CacheManagerMetrics metric = CacheManagerMetrics.getStat(attrName);
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(String.format("Unknown metric %s", attrName));
        } else if (cacheManager == null) {
            context.getFailureDescription().set(String.format("Unavailable cache container %s", attrName));
        } else {
            switch (metric) {
                case CACHE_MANAGER_STATUS: {
                    result.set(SecurityActions.getCacheManagerStatus((EmbeddedCacheManager)cacheManager).toString());
                    break;
                }
                case IS_COORDINATOR: {
                    result.set(SecurityActions.getCacheManagerIsCoordinator(cacheManager));
                    break;
                }
                case LOCAL_ADDRESS: {
                    Address localAddress = SecurityActions.getCacheManagerLocalAddress(cacheManager);
                    result.set(localAddress != null ? localAddress.toString() : "N/A");
                    break;
                }
                case COORDINATOR_ADDRESS: {
                    Address coordinatorAddress = SecurityActions.getCacheManagerCoordinatorAddress(cacheManager);
                    result.set(coordinatorAddress != null ? coordinatorAddress.toString() : "N/A");
                    break;
                }
                case CLUSTER_AVAILABILITY: {
                    result.set(SecurityActions.getCacheManagerClusterAvailability(cacheManager));
                    break;
                }
                case CLUSTER_NAME: {
                    String clusterName = SecurityActions.getCacheManagerClusterName(cacheManager);
                    result.set(clusterName != null ? clusterName : "N/A");
                    break;
                }
                case DEFINED_CACHE_NAMES: {
                    String definedCacheNames = SecurityActions.getDefinedCacheNames(cacheManager);
                    result.set(definedCacheNames != null ? definedCacheNames : "N/A");
                    break;
                }
                case CLUSTER_SIZE: {
                    List<Address> members = SecurityActions.getMembers(cacheManager);
                    result.set(members != null ? Integer.toString(members.size()) : "N/A");
                    break;
                }
                case CREATED_CACHE_COUNT: {
                    result.set(SecurityActions.getCacheCreatedCount(cacheManager));
                    break;
                }
                case DEFINED_CACHE_COUNT: {
                    result.set(SecurityActions.getDefinedCacheCount(cacheManager));
                    break;
                }
                case MEMBERS: {
                    List<Address> members = SecurityActions.getMembers(cacheManager);
                    result.set(members != null ? members.toString() : "N/A");
                    break;
                }
                case RUNNING_CACHE_COUNT: {
                    result.set(SecurityActions.getRunningCacheCount(cacheManager));
                    break;
                }
                case VERSION: {
                    result.set(Version.getVersion());
                    break;
                }
                default: {
                    context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metric}));
                }
            }
            context.getResult().set(result);
        }
        context.stepCompleted();
    }

    public void registerMetrics(ManagementResourceRegistration container) {
        for (CacheManagerMetrics metric : CacheManagerMetrics.values()) {
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public static enum CacheManagerMetrics {
        CACHE_MANAGER_STATUS("cache-manager-status", ModelType.STRING, true),
        CLUSTER_NAME("cluster-name", ModelType.STRING, true, true),
        CLUSTER_AVAILABILITY("cluster-availability", ModelType.STRING, true, true),
        IS_COORDINATOR("is-coordinator", ModelType.BOOLEAN, true, true),
        COORDINATOR_ADDRESS("coordinator-address", ModelType.STRING, true, true),
        LOCAL_ADDRESS("local-address", ModelType.STRING, true, true),
        DEFINED_CACHE_NAMES("defined-cache-names", ModelType.INT, true, true),
        DEFINED_CACHE_COUNT("defined-cache-count", ModelType.INT, true, true),
        RUNNING_CACHE_COUNT("running-cache-count", ModelType.INT, true, true),
        CREATED_CACHE_COUNT("created-cache-count", ModelType.INT, true, true),
        MEMBERS("members", ModelType.INT, true, true),
        CLUSTER_SIZE("cluster-size", ModelType.INT, true, true),
        VERSION("version", ModelType.INT, true, true);

        private static final Map<String, CacheManagerMetrics> MAP;
        final AttributeDefinition definition;
        final boolean clustered;

        private CacheManagerMetrics(AttributeDefinition definition, boolean clustered) {
            this.definition = definition;
            this.clustered = clustered;
        }

        private CacheManagerMetrics(String attributeName, ModelType type, boolean allowNull) {
            this(attributeName, type, allowNull, false);
        }

        private CacheManagerMetrics(String attributeName, ModelType type, boolean allowNull, boolean clustered) {
            this((AttributeDefinition)new SimpleAttributeDefinitionBuilder(attributeName, type, allowNull).setStorageRuntime().build(), clustered);
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static CacheManagerMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, CacheManagerMetrics>();
            for (CacheManagerMetrics metric : CacheManagerMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

