/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.LocalTopologyManagerImpl;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class RebalancingAttributeHandler
implements OperationStepHandler {
    public static final RebalancingAttributeHandler INSTANCE = new RebalancingAttributeHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheService.getServiceName(cacheContainerName, cacheName));
        Cache cache = (Cache)controller.getValue();
        LocalTopologyManagerImpl localTopologyManager = (LocalTopologyManagerImpl)cache.getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry().getComponent(LocalTopologyManager.class);
        if (localTopologyManager != null) {
            try {
                if (operation.hasDefined("value")) {
                    ModelNode newValue = operation.get("value");
                    localTopologyManager.setRebalancingEnabled(newValue.asBoolean());
                } else {
                    context.getResult().set(new ModelNode().set(localTopologyManager.isRebalancingEnabled()));
                }
            }
            catch (Exception e) {
                throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
            }
        }
        context.stepCompleted();
    }
}

