/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.jmx.MBeanServerLookup;
import org.jboss.as.clustering.infinispan.ChannelProvider;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.ManagedExecutorFactory;
import org.jboss.as.clustering.infinispan.ManagedScheduledExecutorFactory;
import org.jboss.as.clustering.infinispan.io.SimpleExternalizer;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class EmbeddedCacheManagerConfigurationService
implements Service<EmbeddedCacheManagerConfiguration>,
EmbeddedCacheManagerConfiguration {
    private final String name;
    private final String defaultCache;
    private final Dependencies dependencies;
    private final ModuleIdentifier moduleId;
    private volatile GlobalConfiguration config;

    public static ServiceName getServiceName(String name) {
        return EmbeddedCacheManagerService.getServiceName(name).append(new String[]{"config"});
    }

    public EmbeddedCacheManagerConfigurationService(String name, String defaultCache, ModuleIdentifier moduleIdentifier, Dependencies dependencies) {
        this.name = name;
        this.defaultCache = defaultCache;
        this.moduleId = moduleIdentifier;
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultCache() {
        return this.defaultCache;
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.config;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleId;
    }

    public EmbeddedCacheManagerConfiguration getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService evictionExecutor;
        Executor listenerExecutor;
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        ModuleLoader moduleLoader = this.dependencies.getModuleLoader();
        builder.serialization().classResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader));
        try {
            ClassLoader loader = this.moduleId != null ? moduleLoader.loadModule(this.moduleId).getClassLoader() : EmbeddedCacheManagerConfiguration.class.getClassLoader();
            builder.classLoader(loader);
            int id = 255;
            for (SimpleExternalizer externalizer : ServiceLoader.load(SimpleExternalizer.class, loader)) {
                builder.serialization().addAdvancedExternalizer(id++, (AdvancedExternalizer)externalizer);
            }
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        TransportConfiguration transport = this.dependencies.getTransportConfiguration();
        TransportConfigurationBuilder transportBuilder = builder.transport();
        if (transport != null) {
            ChannelProvider.init(transportBuilder, ChannelService.getServiceName((String)this.name));
            Long timeout = transport.getLockTimeout();
            if (timeout != null) {
                transportBuilder.distributedSyncTimeout(timeout.longValue());
            }
            boolean strictPeerToPeer = transport.isStrictPeerToPeer();
            transportBuilder.strictPeerToPeer(Boolean.valueOf(strictPeerToPeer));
            TransportConfiguration.Topology topology = transport.getChannelFactory().getProtocolStackConfiguration().getTransport().getTopology();
            if (topology != null) {
                String machine;
                String rack;
                String site = topology.getSite();
                if (site != null) {
                    transportBuilder.siteId(site);
                }
                if ((rack = topology.getRack()) != null) {
                    transportBuilder.rackId(rack);
                }
                if ((machine = topology.getMachine()) != null) {
                    transportBuilder.machineId(machine);
                }
            }
            transportBuilder.clusterName(this.name);
            Executor executor = transport.getExecutor();
            if (executor != null) {
                builder.asyncTransportExecutor().factory((ExecutorFactory)new ManagedExecutorFactory(executor));
            }
        }
        if ((listenerExecutor = this.dependencies.getListenerExecutor()) != null) {
            builder.asyncListenerExecutor().factory((ExecutorFactory)new ManagedExecutorFactory(listenerExecutor));
        }
        if ((evictionExecutor = this.dependencies.getEvictionExecutor()) != null) {
            builder.evictionScheduledExecutor().factory((ScheduledExecutorFactory)new ManagedScheduledExecutorFactory(evictionExecutor));
        }
        if ((replicationQueueExecutor = this.dependencies.getReplicationQueueExecutor()) != null) {
            builder.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)new ManagedScheduledExecutorFactory(replicationQueueExecutor));
        }
        GlobalJmxStatisticsConfigurationBuilder jmxBuilder = builder.globalJmxStatistics().cacheManagerName(this.name);
        MBeanServer server = this.dependencies.getMBeanServer();
        if (server != null) {
            jmxBuilder.enable().mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).jmxDomain(EmbeddedCacheManagerService.getServiceName(null).getCanonicalName()).allowDuplicateDomains(Boolean.valueOf(true));
        } else {
            jmxBuilder.disable();
        }
        this.config = builder.build();
    }

    public void stop(StopContext context) {
    }

    static interface Dependencies {
        public ModuleLoader getModuleLoader();

        public TransportConfiguration getTransportConfiguration();

        public MBeanServer getMBeanServer();

        public Executor getListenerExecutor();

        public ScheduledExecutorService getEvictionExecutor();

        public ScheduledExecutorService getReplicationQueueExecutor();
    }

    static interface TransportConfiguration {
        public Long getLockTimeout();

        public ChannelFactory getChannelFactory();

        public Executor getExecutor();

        public boolean isStrictPeerToPeer();
    }
}

