/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.dmr.ModelNode;

public class RemoveAliasCommand
implements OperationStepHandler {
    public static final RemoveAliasCommand INSTANCE = new RemoveAliasCommand();
    private final ParametersValidator nameValidator = new ParametersValidator();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String aliasToRemove = operation.require("name").asString();
        ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode currentValue = submodel.get(CacheContainerResource.ALIASES.getName()).clone();
        ModelNode newValue = this.removeAliasFromList(currentValue, aliasToRemove);
        ModelNode syntheticOp = new ModelNode();
        syntheticOp.get(CacheContainerResource.ALIASES.getName()).set(newValue);
        CacheContainerResource.ALIASES.validateAndSet(syntheticOp, submodel);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType().isServer() && !context.isBooting();
    }

    private ModelNode removeAliasFromList(ModelNode list, String alias) throws OperationFailedException {
        if (alias == null || alias.equals("")) {
            return list;
        }
        if (!list.isDefined()) {
            throw InfinispanMessages.MESSAGES.cannotRemoveAliasFromEmptyList(alias);
        }
        ModelNode newList = new ModelNode();
        List listElements = list.asList();
        for (ModelNode listElement : listElements) {
            if (listElement.asString().equals(alias)) continue;
            newList.add().set(listElement);
        }
        return newList;
    }
}

