/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.eventlogger.ExternalizerIds;
import org.infinispan.server.eventlogger.ServerEventImpl;
import org.infinispan.server.eventlogger.ServerEventLogger;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;

public class LifecycleCallbacks
extends AbstractModuleLifecycle {
    private EventLogger oldEventLogger;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration gc) {
        Map externalizerMap = gc.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.SERVER_EVENT, new ServerEventImpl.Externalizer());
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("___event_log_cache", this.getTaskHistoryCacheConfiguration(cacheManager).build(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT, InternalCacheRegistry.Flag.QUERYABLE));
        this.oldEventLogger = ((EventLogManager)gcr.getComponent(EventLogManager.class)).replaceEventLogger((EventLogger)new ServerEventLogger(cacheManager, gcr.getTimeService()));
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        ((EventLogManager)gcr.getComponent(EventLogManager.class)).replaceEventLogger(this.oldEventLogger);
    }

    private ConfigurationBuilder getTaskHistoryCacheConfiguration(EmbeddedCacheManager cacheManager) {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.eviction().size(100L).persistence().passivation(true).expiration().lifespan(7L, TimeUnit.DAYS);
        return cfg;
    }
}

