/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.server.endpoint.subsystem.EncryptableSubsystemHelper;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestAuthMethod;
import org.infinispan.server.endpoint.subsystem.RestAuthenticationResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

class RestSubsystemAdd
extends AbstractAddStepHandler {
    static final RestSubsystemAdd INSTANCE = new RestSubsystemAdd();

    RestSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        RestAuthMethod restAuthMethod = RestAuthMethod.NONE;
        ModelNode authConfig = null;
        if (config.hasDefined("authentication") && config.get(new String[]{"authentication", "AUTHENTICATION"}).isDefined()) {
            authConfig = config.get(new String[]{"authentication", "AUTHENTICATION"});
            restAuthMethod = RestAuthMethod.valueOf(RestAuthenticationResource.AUTH_METHOD.resolveModelAttribute(context, authConfig).asString());
        }
        String contextPath = RestConnectorResource.CONTEXT_PATH.resolveModelAttribute(context, config).asString();
        ExtendedHeaders extendedHeaders = ExtendedHeaders.valueOf((String)RestConnectorResource.EXTENDED_HEADERS.resolveModelAttribute(context, config).asString());
        Set<String> ignoredCaches = Collections.emptySet();
        if (config.hasDefined("ignored-caches")) {
            ignoredCaches = config.get("ignored-caches").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
        }
        int maxContentLength = RestConnectorResource.MAX_CONTENT_LENGTH.resolveModelAttribute(context, config).asInt();
        int compressLevel = RestConnectorResource.COMPRESSION_LEVEL.resolveModelAttribute(context, config).asInt();
        List<CorsConfig> corsConfig = this.getCorsConfig(config);
        RestService service = new RestService(this.getServiceName(config), restAuthMethod, RestSubsystemAdd.cleanContextPath(contextPath), extendedHeaders, ignoredCaches, maxContentLength, compressLevel, corsConfig);
        ServiceBuilder builder = context.getServiceTarget().addService(EndpointUtils.getServiceName(operation, "rest"), (Service)service);
        String cacheContainerName = config.hasDefined("cache-container") ? config.get("cache-container").asString() : null;
        EndpointUtils.addCacheContainerDependency(builder, cacheContainerName, service.getCacheManager());
        EndpointUtils.addCacheDependency(builder, cacheContainerName, null);
        EndpointUtils.addSocketBindingDependency(context, builder, this.getSocketBindingName(operation), service.getSocketBinding());
        EndpointUtils.addSocketBindingDependency(context, builder, "management-http", service.getSocketBindingManagementPlain());
        EndpointUtils.addSocketBindingDependency(context, builder, "management-https", service.getSocketBindingManagementSecured());
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector());
        if (authConfig != null && authConfig.hasDefined("security-realm")) {
            EndpointUtils.addSecurityRealmDependency(builder, RestAuthenticationResource.SECURITY_REALM.resolveModelAttribute(context, authConfig).asString(), service.getAuthenticationSecurityRealm());
        }
        EncryptableSubsystemHelper.processEncryption((ExpressionResolver)context, config, service, builder);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    private static String cleanContextPath(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected String getSocketBindingName(ModelNode config) {
        return config.hasDefined("socket-binding") ? config.get("socket-binding").asString() : null;
    }

    protected String getServiceName(ModelNode config) {
        return config.hasDefined("name") ? config.get("name").asString() : "";
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        RestSubsystemAdd.populate(source, target);
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_LIST_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : RestConnectorResource.REST_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
    }

    private List<CorsConfig> getCorsConfig(ModelNode modelNode) {
        ArrayList<CorsConfig> corsConfigList = new ArrayList<CorsConfig>();
        if (modelNode.hasDefined("cors-rule")) {
            List rules = modelNode.get("cors-rule").asList();
            for (ModelNode rule : rules) {
                ModelNode ruleDefinition = rule.get((String)rule.keys().iterator().next());
                Integer maxAgeSeconds = this.extractInt(ruleDefinition, "max-age-seconds");
                Boolean allowCredentials = this.extractBool(ruleDefinition, "allow-credentials");
                String[] origins = this.asArray(ruleDefinition, "allowed-origins");
                String[] methods = this.asArray(ruleDefinition, "allowed-methods");
                String[] headers = this.asArray(ruleDefinition, "allowed-headers");
                String[] exposes = this.asArray(ruleDefinition, "expose-headers");
                HttpMethod[] httpMethods = (HttpMethod[])Arrays.stream(methods).map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
                CorsConfigBuilder builder = Arrays.stream(origins).anyMatch(s -> s.equals("*")) ? CorsConfigBuilder.forAnyOrigin() : CorsConfigBuilder.forOrigins((String[])origins);
                builder.allowedRequestMethods(httpMethods);
                if (headers.length > 0) {
                    builder.allowedRequestHeaders(headers);
                }
                if (exposes.length > 0) {
                    builder.exposeHeaders(exposes);
                }
                if (maxAgeSeconds != null) {
                    builder.maxAge((long)maxAgeSeconds.intValue());
                }
                if (allowCredentials.booleanValue()) {
                    builder.allowCredentials();
                }
                corsConfigList.add(builder.build());
            }
        }
        return corsConfigList;
    }

    private String[] asArray(ModelNode node, String listProperty) {
        if (node != null && node.isDefined() && node.hasDefined(listProperty)) {
            return (String[])node.get(listProperty).asList().stream().map(ModelNode::asString).toArray(String[]::new);
        }
        return new String[0];
    }

    private Integer extractInt(ModelNode node, String property) {
        if (node != null && node.isDefined() && node.hasDefined(property)) {
            return node.get(property).asInt();
        }
        return null;
    }

    private Boolean extractBool(ModelNode node, String property) {
        return node != null && node.isDefined() && node.hasDefined(property) && node.get(property).asBoolean();
    }
}

