/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class ProtocolServiceSubsystemAdd
extends AbstractAddStepHandler {
    protected String getServiceName(ModelNode config) {
        return config.hasDefined("name") ? config.get("name").asString() : null;
    }

    protected String getSocketBindingName(ModelNode config) {
        return config.hasDefined("socket-binding") ? config.get("socket-binding").asString() : null;
    }

    protected String getCacheContainerName(ModelNode config) {
        return config.hasDefined("cache-container") ? config.get("cache-container").asString() : null;
    }

    protected void configureProtocolServer(OperationContext context, ProtocolServerConfigurationBuilder<?, ?> builder, ModelNode config) throws OperationFailedException {
        if (config.hasDefined("name")) {
            builder.name(config.get("name").asString());
        }
        builder.ioThreads(ProtocolServerConnectorResource.IO_THREADS.resolveModelAttribute(context, config).asInt());
        builder.workerThreads(ProtocolServerConnectorResource.WORKER_THREADS.resolveModelAttribute(context, config).asInt());
        builder.idleTimeout(ProtocolServerConnectorResource.IDLE_TIMEOUT.resolveModelAttribute(context, config).asInt());
        builder.tcpNoDelay(ProtocolServerConnectorResource.TCP_NODELAY.resolveModelAttribute(context, config).asBoolean());
        builder.tcpKeepAlive(ProtocolServerConnectorResource.TCP_KEEPALIVE.resolveModelAttribute(context, config).asBoolean());
        builder.recvBufSize(ProtocolServerConnectorResource.RECEIVE_BUFFER_SIZE.resolveModelAttribute(context, config).asInt());
        builder.sendBufSize(ProtocolServerConnectorResource.SEND_BUFFER_SIZE.resolveModelAttribute(context, config).asInt());
        if (config.hasDefined("ignored-caches")) {
            Set ignoredCaches = config.get("ignored-caches").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
            builder.ignoredCaches(ignoredCaches);
        }
    }
}

