/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.MemcachedConnectorResource;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.ProtocolServerService;
import org.infinispan.server.endpoint.subsystem.ProtocolServiceSubsystemAdd;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;

class MemcachedSubsystemAdd
extends ProtocolServiceSubsystemAdd {
    static final MemcachedSubsystemAdd INSTANCE = new MemcachedSubsystemAdd();

    MemcachedSubsystemAdd() {
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        target.setEmptyObject();
        for (SimpleAttributeDefinition attr : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition attr : ProtocolServerConnectorResource.PROTOCOL_SERVICE_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition attr : MemcachedConnectorResource.MEMCACHED_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        String cacheName = MemcachedConnectorResource.CACHE.resolveModelAttribute(context, config).asString();
        String clientEncoding = MemcachedConnectorResource.CLIENT_ENCODING.resolveModelAttribute(context, config).asString();
        MemcachedServerConfigurationBuilder configurationBuilder = new MemcachedServerConfigurationBuilder();
        configurationBuilder.clientEncoding(MediaType.parse((String)clientEncoding));
        this.configureProtocolServer(context, (ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder, config);
        ProtocolServerService service = new ProtocolServerService(this.getServiceName(operation), (Class<? extends ProtocolServer>)MemcachedServer.class, (ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder, cacheName);
        ServiceBuilder builder = context.getServiceTarget().addService(EndpointUtils.getServiceName(operation, "memcached"), (Service)service);
        String cacheContainerName = this.getCacheContainerName(operation);
        EndpointUtils.addCacheContainerDependency(builder, cacheContainerName, service.getCacheManager());
        EndpointUtils.addCacheDependency(builder, cacheContainerName, cacheName);
        EndpointUtils.addCacheDependency(builder, cacheContainerName, null);
        EndpointUtils.addSocketBindingDependency(context, builder, this.getSocketBindingName(operation), service.getSocketBinding());
        builder.install();
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        MemcachedSubsystemAdd.populate(source, target);
    }
}

