/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.server.endpoint.subsystem.EncryptableService;
import org.infinispan.server.endpoint.subsystem.EncryptionResource;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.SniResource;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;

public class EncryptableSubsystemHelper {
    private EncryptableSubsystemHelper() {
    }

    static void processEncryption(ExpressionResolver context, ModelNode config, EncryptableService service, ServiceBuilder<?> builder) throws OperationFailedException {
        if (config.hasDefined("encryption") && config.get(new String[]{"encryption", "ENCRYPTION"}).isDefined()) {
            config = config.get(new String[]{"encryption", "ENCRYPTION"});
            EndpointUtils.addSecurityRealmDependency(builder, EncryptionResource.SECURITY_REALM.resolveModelAttribute(context, config).asString(), service.getEncryptionSecurityRealm());
            if (config.get("sni").isDefined()) {
                for (ModelNode sniConfiguration : config.get("sni").asList()) {
                    ModelNode sni = sniConfiguration.get(0);
                    if (!sni.hasDefined("security-realm")) continue;
                    String sniHostName = SniResource.HOST_NAME.resolveModelAttribute(context, sni).asString();
                    String securityRealm = SniResource.SECURITY_REALM.resolveModelAttribute(context, sni).asString();
                    EndpointUtils.addSecurityRealmDependency(builder, securityRealm, service.getSniSecurityRealm(sniHostName));
                }
            }
            service.setClientAuth(EncryptionResource.REQUIRE_SSL_CLIENT_AUTH.resolveModelAttribute(context, config).asBoolean());
        }
    }
}

