/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Element {
    UNKNOWN((String)null),
    HOTROD_CONNECTOR("hotrod-connector"),
    MEMCACHED_CONNECTOR("memcached-connector"),
    REST_CONNECTOR("rest-connector"),
    ROUTER_CONNECTOR("router-connector"),
    WEBSOCKET_CONNECTOR("websocket-connector"),
    ALLOWED_ORIGINS("allowed-origins"),
    ALLOWED_METHODS("allowed-methods"),
    ALLOWED_HEADERS("allowed-headers"),
    EXPOSE_HEADERS("expose-headers"),
    AUTHENTICATION("authentication"),
    HOTROD("hotrod"),
    REST("rest"),
    ENCRYPTION("encryption"),
    CORS_RULES("cors-rules"),
    CORS_RULE("cors-rule"),
    SNI("sni"),
    PREFIX("prefix"),
    SECURITY("security"),
    TOPOLOGY_STATE_TRANSFER("topology-state-transfer"),
    INCLUDE_MECHANISMS("mechanisms"),
    QOP("qop"),
    POLICY("policy"),
    PROPERTY("property"),
    SASL("sasl"),
    STRENGTH("strength"),
    FORWARD_SECRECY("forward-secrecy"),
    NO_ACTIVE("no-active"),
    NO_ANONYMOUS("no-anonymous"),
    NO_DICTIONARY("no-dictionary"),
    NO_PLAIN_TEXT("no-plain-text"),
    PASS_CREDENTIALS("pass-credentials"),
    MULTI_TENANCY("multi-tenancy"),
    SINGLE_PORT("single-port");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
        this.definition = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

