/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.commons.controller;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.dmr.ModelNode;

public final class Operations {
    public static PathAddress getPathAddress(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address"));
    }

    public static String getName(ModelNode operation) {
        return operation.require("operation").asString();
    }

    public static String getAttributeName(ModelNode operation) {
        return operation.require("name").asString();
    }

    public static ModelNode getAttributeValue(ModelNode operation) {
        return operation.hasDefined("value") ? operation.get("value") : new ModelNode();
    }

    public static ModelNode createCompositeOperation(List<ModelNode> operations) {
        ModelNode operation = Util.createOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        ModelNode steps = operation.get("steps");
        for (ModelNode step : operations) {
            steps.add(step);
        }
        return operation;
    }

    public static ModelNode createCompositeOperation(ModelNode ... operations) {
        return Operations.createCompositeOperation(Arrays.asList(operations));
    }

    public static ModelNode createReadAttributeOperation(PathAddress address, String name) {
        return Operations.createAttributeOperation("read-attribute", address, name);
    }

    public static ModelNode createWriteAttributeOperation(PathAddress address, String name, ModelNode value) {
        ModelNode operation = Operations.createAttributeOperation("write-attribute", address, name);
        operation.get("value").set(value);
        return operation;
    }

    public static ModelNode createUndefineAttributeOperation(PathAddress address, String name) {
        return Operations.createAttributeOperation("undefine-attribute", address, name);
    }

    private static ModelNode createAttributeOperation(String operationName, PathAddress address, String attributeName) {
        ModelNode operation = Util.createOperation((String)operationName, (PathAddress)address);
        operation.get("name").set(attributeName);
        return operation;
    }

    public static ModelNode createDescribeOperation(PathAddress address) {
        return Util.createOperation((String)"describe", (PathAddress)address);
    }

    public static ModelNode createListAddOperation(PathAddress address, String attributeName, String value) {
        return Operations.createListElementOperation(ListOperations.LIST_ADD_DEFINITION, address, attributeName, value);
    }

    public static ModelNode createListRemoveOperation(PathAddress address, String attributeName, String value) {
        return Operations.createListElementOperation(ListOperations.LIST_REMOVE_DEFINITION, address, attributeName, value);
    }

    public static ModelNode createListRemoveOperation(PathAddress address, String attributeName, int index) {
        return Operations.createListElementOperation(ListOperations.LIST_REMOVE_DEFINITION, address, attributeName, index);
    }

    public static ModelNode createListGetOperation(PathAddress address, String attributeName, int index) {
        return Operations.createListElementOperation(ListOperations.LIST_GET_DEFINITION, address, attributeName, index);
    }

    private static ModelNode createListElementOperation(OperationDefinition definition, PathAddress address, String attributeName, String value) {
        ModelNode operation = Operations.createAttributeOperation(definition.getName(), address, attributeName);
        operation.get("value").set(value);
        return operation;
    }

    private static ModelNode createListElementOperation(OperationDefinition definition, PathAddress address, String attributeName, int index) {
        ModelNode operation = Operations.createAttributeOperation(definition.getName(), address, attributeName);
        operation.get("index").set(new ModelNode(index));
        return operation;
    }

    public static ModelNode createMapGetOperation(PathAddress address, String attributeName, String key) {
        return Operations.createMapEntryOperation(MapOperations.MAP_GET_DEFINITION, address, attributeName, key);
    }

    public static ModelNode createMapPutOperation(PathAddress address, String attributeName, String key, String value) {
        ModelNode operation = Operations.createMapEntryOperation(MapOperations.MAP_PUT_DEFINITION, address, attributeName, key);
        operation.get("value").set(value);
        return operation;
    }

    public static ModelNode createMapRemoveOperation(PathAddress address, String attributeName, String key) {
        return Operations.createMapEntryOperation(MapOperations.MAP_REMOVE_DEFINITION, address, attributeName, key);
    }

    private static ModelNode createMapEntryOperation(OperationDefinition definition, PathAddress address, String attributeName, String key) {
        ModelNode operation = Operations.createAttributeOperation(definition.getName(), address, attributeName);
        operation.get("key").set(key);
        return operation;
    }

    private Operations() {
    }
}

