/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.commons.naming;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.server.commons.service.Builder;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class BinderServiceBuilder<T>
implements Builder<ManagedReferenceFactory> {
    private final ContextNames.BindInfo binding;
    private final ServiceName targetServiceName;
    private final Class<T> targetClass;
    private final List<ContextNames.BindInfo> aliases = new LinkedList<ContextNames.BindInfo>();

    public BinderServiceBuilder(ContextNames.BindInfo binding, ServiceName targetServiceName, Class<T> targetClass) {
        this.binding = binding;
        this.targetServiceName = targetServiceName;
        this.targetClass = targetClass;
    }

    public BinderServiceBuilder<T> alias(ContextNames.BindInfo alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public ServiceName getServiceName() {
        return this.binding.getBinderServiceName();
    }

    @Override
    public ServiceBuilder<ManagedReferenceFactory> build(ServiceTarget target) {
        String name = this.binding.getBindName();
        BinderService binder = new BinderService(name);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{name})}).addDependency(this.targetServiceName, this.targetClass, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(this.binding.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector());
        for (ContextNames.BindInfo alias : this.aliases) {
            builder.addAliases(new ServiceName[]{alias.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{alias.getBindName()})});
        }
        return builder.setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

