/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.commons.controller.validation;

import org.infinispan.server.commons.controller.validation.ParameterValidatorBuilder;
import org.infinispan.server.commons.logging.ClusteringLogger;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DoubleRangeValidatorBuilder
implements ParameterValidatorBuilder {
    private Bound upperBound;
    private Bound lowerBound;
    private boolean allowsUndefined = false;
    private boolean allowsExpression = false;

    public DoubleRangeValidatorBuilder lowerBound(double value) {
        this.lowerBound = new Bound(value, false);
        return this;
    }

    public DoubleRangeValidatorBuilder lowerBoundExclusive(double value) {
        this.lowerBound = new Bound(value, true);
        return this;
    }

    public DoubleRangeValidatorBuilder upperBound(double value) {
        this.upperBound = new Bound(value, false);
        return this;
    }

    public DoubleRangeValidatorBuilder upperBoundExclusive(double value) {
        this.upperBound = new Bound(value, true);
        return this;
    }

    public DoubleRangeValidatorBuilder allowUndefined(boolean allowsUndefined) {
        this.allowsUndefined = allowsUndefined;
        return this;
    }

    public DoubleRangeValidatorBuilder allowExpression(boolean allowsExpressions) {
        this.allowsExpression = allowsExpressions;
        return this;
    }

    @Override
    public ParameterValidator build() {
        return new DoubleRangeValidator(this.lowerBound, this.upperBound, this.allowsUndefined, this.allowsExpression);
    }

    private class DoubleRangeValidator
    extends ModelTypeValidator {
        private final Bound lowerBound;
        private final Bound upperBound;

        DoubleRangeValidator(Bound lowerBound, Bound upperBound, boolean nullable, boolean allowExpressions) {
            super(ModelType.DOUBLE, nullable, allowExpressions, false);
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public void validateParameter(String parameterName, ModelNode parameterValue) throws OperationFailedException {
            super.validateParameter(parameterName, parameterValue);
            if (parameterValue.isDefined() && parameterValue.getType() != ModelType.EXPRESSION) {
                boolean exclusive;
                double bound;
                double value = parameterValue.asDouble();
                if (this.lowerBound != null) {
                    bound = this.lowerBound.getValue();
                    exclusive = this.lowerBound.isExclusive();
                    if (value < bound || exclusive && value == bound) {
                        throw ClusteringLogger.ROOT_LOGGER.parameterValueOutOfBounds(parameterName, value, exclusive ? ">" : ">=", bound);
                    }
                }
                if (this.upperBound != null) {
                    bound = this.upperBound.getValue();
                    exclusive = this.upperBound.isExclusive();
                    if (value > bound || exclusive && value == bound) {
                        throw ClusteringLogger.ROOT_LOGGER.parameterValueOutOfBounds(parameterName, value, exclusive ? "<" : "<=", bound);
                    }
                }
            }
        }
    }

    private static class Bound {
        private final double value;
        private final boolean exclusive;

        Bound(double value, boolean exclusive) {
            this.value = value;
            this.exclusive = exclusive;
        }

        double getValue() {
            return this.value;
        }

        boolean isExclusive() {
            return this.exclusive;
        }
    }
}

