/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.plugins.proto.compatibility;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.ProtoLock;
import org.infinispan.protostream.impl.parser.ProtostreamProtoParser;

@Mojo(name="proto-schema-compatibility-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ProtoCompatibilityMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}")
    private String protoLockRoot;
    @Parameter(defaultValue="${project.build.directory}/classes/proto", readonly=true)
    private String protoSourceRoot;
    @Parameter(defaultValue="false")
    private boolean commitProtoLock;

    public void execute() throws MojoExecutionException {
        block31: {
            try {
                ProtoLock protoOld;
                List<Path> protoFiles;
                Path lockFile = Paths.get(this.protoLockRoot, "proto.lock");
                boolean lockFileExists = Files.exists(lockFile, new LinkOption[0]);
                if (!this.commitProtoLock && !lockFileExists) {
                    this.getLog().info((CharSequence)"Ignoring protolock check as there isn't an existing proto.lock file and commitProtoLock=false.");
                    return;
                }
                Path protoRoot = Paths.get(this.protoSourceRoot, new String[0]);
                try (Stream<Path> stream = Files.walk(protoRoot, new FileVisitOption[0]);){
                    protoFiles = stream.filter(p -> p.getFileName().toString().endsWith(".proto")).toList();
                }
                FileDescriptorSource fds = new FileDescriptorSource();
                for (Path p2 : protoFiles) {
                    fds.addProtoFile(protoRoot.relativize(p2).toString(), p2.toFile());
                }
                ProtostreamProtoParser parser = new ProtostreamProtoParser(Configuration.builder().build());
                Map descriptors = parser.parse(fds);
                ProtoLock protoNew = new ProtoLock(descriptors.values());
                if (!lockFileExists) {
                    try (OutputStream os = Files.newOutputStream(lockFile, new OpenOption[0]);){
                        protoNew.writeLockFile(os);
                    }
                    this.getLog().info((CharSequence)"Initialized protolock.");
                    break block31;
                }
                try (InputStream is = Files.newInputStream(lockFile, new OpenOption[0]);){
                    protoOld = ProtoLock.readLockFile((InputStream)is);
                }
                protoOld.checkCompatibility(protoNew, true);
                this.getLog().info((CharSequence)"Backwards compatibility check passed.");
                if (!this.commitProtoLock) break block31;
                try (OutputStream os = Files.newOutputStream(lockFile, new OpenOption[0]);){
                    protoNew.writeLockFile(os);
                }
                this.getLog().info((CharSequence)"Schema changes committed to proto.lock.");
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while running protolock", (Exception)e);
            }
        }
    }
}

