/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.infinispan.ppg.generator.Branch;
import org.infinispan.ppg.generator.GeneratorException;
import org.infinispan.ppg.generator.Grammar;
import org.infinispan.ppg.generator.Machine;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.Resolvable;

public class RuleDefinition
implements Resolvable {
    final String qualifiedName;
    final String sourceName;
    final String file;
    final int line;
    final List<Branch> branches = new ArrayList<Branch>();
    String explicitType;
    Reference switchOn;

    public RuleDefinition(String ns, String unqualifiedName, String file, int line) {
        this.qualifiedName = ns + "." + unqualifiedName;
        this.sourceName = this.qualifiedName.replaceAll("\\.", "_");
        this.file = file;
        this.line = line;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(String.format("%s:%d: ", this.file, this.line)).append(this.qualifiedName).append(" :\n\t");
        Iterator<Branch> it = this.branches.iterator();
        if (!it.hasNext()) {
            sb.append("<no branches?> ;");
        }
        while (true) {
            sb.append(it.next()).append("\n\t");
            if (!it.hasNext()) break;
            sb.append("| ");
        }
        sb.append(";\n");
        return sb.toString();
    }

    public void addReferences(Set<Reference> references) {
        if (this.switchOn != null) {
            references.add(this.switchOn);
        }
        for (Branch b : this.branches) {
            b.addReferences(references);
        }
    }

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    @Override
    public Machine.State addStates(Machine.State prev, Machine.State target, Machine machine, Grammar grammar, List<RuleDefinition> ruleStack, Reference reference) {
        if (reference.params != null) {
            throw new GeneratorException(reference.file + ":" + reference.line + ": Invalid reference to " + this.qualifiedName + ", rules cannot have parameters!");
        }
        for (RuleDefinition rule : ruleStack) {
            if (rule != this) continue;
            StringBuilder sb = new StringBuilder("Illegal recursion: ");
            for (RuleDefinition r : ruleStack) {
                if (r == this) {
                    sb.append("***");
                }
                sb.append(r.qualifiedName);
                if (r == this) {
                    sb.append("***");
                }
                sb.append(" -> ");
            }
            sb.append(rule.qualifiedName);
            throw new GeneratorException(sb.toString());
        }
        ruleStack.add(this);
        if (this.switchOn != null) {
            prev.setSwitch(this.switchOn.sourceName);
        }
        Iterator<Branch> iterator = this.branches.iterator();
        while (iterator.hasNext()) {
            Branch b = iterator.next();
            if (b.sentinel == null && iterator.hasNext()) {
                throw new GeneratorException(b.file + ":" + b.line + ": All but the last branches need sentinel predicates!");
            }
            b.addStates(prev, target, machine, grammar, ruleStack);
        }
        RuleDefinition self = ruleStack.remove(ruleStack.size() - 1);
        assert (this == self);
        return target;
    }

    @Override
    public String analyzeType(Grammar grammar) {
        if (this.explicitType != null) {
            return this.explicitType;
        }
        String commonType = null;
        for (Branch b : this.branches) {
            String branchType = b.analyzeType(grammar);
            if ("throw".equals(branchType)) continue;
            if (commonType == null) {
                commonType = branchType;
                continue;
            }
            if (commonType.equals(branchType)) continue;
            throw new GeneratorException(this.file + ":" + this.line + ": rule " + this.qualifiedName + ": Branches analyzed to different types; " + commonType + " != " + branchType);
        }
        return commonType == null ? "void" : commonType;
    }
}

