/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.tools.jdbc.migrator.Element;
import org.infinispan.tools.jdbc.migrator.MarshallerType;
import org.infinispan.tools.jdbc.migrator.StoreType;
import org.infinispan.tools.jdbc.migrator.marshaller.LegacyVersionAwareMarshaller;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

class MigratorConfiguration {
    final String cacheName;
    final StoreType storeType;
    private final Properties properties;
    private final boolean sourceStore;
    private final Element orientation;
    private final ClassLoader classLoader;
    private DbMetaData dbMetaData;
    private TableManipulationConfiguration stringTable = null;
    private TableManipulationConfiguration binaryTable = null;
    private ConnectionFactoryConfiguration connectionConfig;
    private JdbcStringBasedStoreConfigurationBuilder jdbcConfigBuilder;
    private TwoWayKey2StringMapper key2StringMapper;
    private StreamingMarshaller marshaller;
    private Map<Integer, AdvancedExternalizer<?>> externalizerMap;

    MigratorConfiguration(boolean sourceStore, Properties properties) {
        this.properties = properties;
        this.sourceStore = sourceStore;
        this.orientation = sourceStore ? Element.SOURCE : Element.TARGET;
        this.classLoader = MigratorConfiguration.class.getClassLoader();
        this.requiredProps(this.propKey(Element.CACHE_NAME), this.propKey(Element.TYPE));
        this.cacheName = this.property(Element.CACHE_NAME);
        this.storeType = StoreType.valueOf(this.property(Element.TYPE).toUpperCase());
        this.initStoreConfig();
    }

    private void requiredProps(String ... required) {
        for (String prop : required) {
            if (this.properties.get(prop) != null) continue;
            String msg = String.format("The property %s must be specified.", prop);
            throw new CacheConfigurationException(msg);
        }
    }

    private void initStoreConfig() {
        JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.dbMetaData = this.createDbMeta(builder);
        this.connectionConfig = this.createConnectionConfig(builder);
        this.marshaller = this.createMarshaller();
        if (this.sourceStore) {
            if (this.storeType == StoreType.MIXED || this.storeType == StoreType.STRING) {
                this.stringTable = this.createTableConfig(Element.STRING, builder);
                this.key2StringMapper = this.createTwoWayMapper();
            }
            if (this.storeType == StoreType.MIXED || this.storeType == StoreType.BINARY) {
                this.binaryTable = this.createTableConfig(Element.BINARY, builder);
            }
        } else {
            this.key2StringMapper = this.createTwoWayMapper();
            builder.key2StringMapper(this.key2StringMapper.getClass());
            this.stringTable = this.createTableConfig(Element.STRING, builder);
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        }
        builder.validate();
        this.jdbcConfigBuilder = builder;
    }

    private DbMetaData createDbMeta(JdbcStringBasedStoreConfigurationBuilder builder) {
        String disableIndexing;
        boolean indexing;
        String disableUpsert;
        boolean upsert;
        this.requiredProps(this.propKey(Element.DIALECT));
        DatabaseType type = DatabaseType.valueOf((String)this.property(Element.DIALECT).toUpperCase());
        builder.dialect(type);
        Integer major = null;
        String prop = this.property(Element.DB, Element.MAJOR_VERSION);
        if (prop != null) {
            major = new Integer(prop);
            builder.dbMajorVersion(major);
        }
        Integer minor = null;
        prop = this.property(Element.DB, Element.MINOR_VERSION);
        if (prop != null) {
            minor = new Integer(prop);
            builder.dbMinorVersion(minor);
        }
        if (upsert = Boolean.parseBoolean(disableUpsert = this.property(Element.DB, Element.DISABLE_UPSERT))) {
            builder.addProperty("infinispan.jdbc.upsert.disabled", disableUpsert);
        }
        if (indexing = Boolean.parseBoolean(disableIndexing = this.property(Element.DB, Element.DISABLE_INDEXING))) {
            builder.addProperty("infinispan.jdbc.indexing.disabled", disableIndexing);
        }
        return new DbMetaData(type, major, minor, upsert, indexing);
    }

    private TableManipulationConfiguration createTableConfig(Element tableType, JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        boolean createOnStart = this.orientation == Element.TARGET;
        return ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)storeBuilder.table().createOnStart(createOnStart)).tableNamePrefix(this.property(Element.TABLE, tableType, Element.TABLE_NAME_PREFIX))).idColumnName(this.property(Element.TABLE, tableType, Element.ID, Element.NAME))).idColumnType(this.property(Element.TABLE, tableType, Element.ID, Element.TYPE))).dataColumnName(this.property(Element.TABLE, tableType, Element.DATA, Element.NAME))).dataColumnType(this.property(Element.TABLE, tableType, Element.DATA, Element.TYPE))).timestampColumnName(this.property(Element.TABLE, tableType, Element.TIMESTAMP, Element.NAME))).timestampColumnType(this.property(Element.TABLE, tableType, Element.TIMESTAMP, Element.TYPE))).create();
    }

    private PooledConnectionFactoryConfiguration createConnectionConfig(JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        this.requiredProps(this.propKey(Element.CONNECTION_POOL, Element.CONNECTION_URL), this.propKey(Element.CONNECTION_POOL, Element.DRIVER_CLASS));
        return storeBuilder.connectionPool().connectionUrl(this.property(Element.CONNECTION_POOL, Element.CONNECTION_URL)).driverClass(this.property(Element.CONNECTION_POOL, Element.DRIVER_CLASS)).username(this.property(Element.CONNECTION_POOL, Element.USERNAME)).password(this.property(Element.CONNECTION_POOL, Element.PASSWORD)).create();
    }

    private TwoWayKey2StringMapper createTwoWayMapper() {
        String mapperClass = this.property(Element.KEY_TO_STRING_MAPPER);
        if (mapperClass != null) {
            ClassLoader classLoader = MigratorConfiguration.class.getClassLoader();
            try {
                return (TwoWayKey2StringMapper)Util.loadClass((String)mapperClass, (ClassLoader)classLoader).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException(String.format("Unabled to load TwoWayKey2StringMapper '%s' for %s store", new Object[]{mapperClass, this.orientation}), (Throwable)e);
            }
        }
        return new DefaultTwoWayKey2StringMapper();
    }

    private StreamingMarshaller createMarshaller() {
        MarshallerType marshallerType = MarshallerType.CURRENT;
        String marshallerTypeProp = this.property(Element.MARSHALLER, Element.TYPE);
        if (marshallerTypeProp != null) {
            marshallerType = MarshallerType.valueOf(this.property(Element.MARSHALLER, Element.TYPE).toUpperCase());
        }
        switch (marshallerType) {
            case CURRENT: {
                this.externalizerMap = this.getExternalizersFromProps();
                if (this.orientation == Element.TARGET) {
                    return null;
                }
                GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder().defaultCacheName(this.cacheName);
                this.addExternalizersToConfig(globalConfig.serialization());
                DefaultCacheManager manager = new DefaultCacheManager(globalConfig.build(), new ConfigurationBuilder().build());
                return (StreamingMarshaller)manager.getCache().getAdvancedCache().getComponentRegistry().getComponent(StreamingMarshaller.class);
            }
            case CUSTOM: {
                String marshallerClass = this.property(Element.MARSHALLER, Element.CLASS);
                if (marshallerClass == null) {
                    throw new CacheConfigurationException(String.format("The property %s.%s must be set if a custom marshaller type is specified", new Object[]{Element.MARSHALLER, Element.CLASS}));
                }
                try {
                    return (StreamingMarshaller)Util.loadClass((String)marshallerClass, (ClassLoader)this.classLoader).newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CacheConfigurationException(String.format("Unabled to load StreamingMarshaller '%s' for %s store", new Object[]{marshallerClass, this.orientation}), (Throwable)e);
                }
            }
            case LEGACY: {
                if (this.orientation != Element.SOURCE) {
                    throw new CacheConfigurationException("The legacy marshaller can only be specified for source stores.");
                }
                return new LegacyVersionAwareMarshaller(this.getExternalizersFromProps());
            }
        }
        throw new IllegalStateException("Unexpected marshaller type");
    }

    private Map<Integer, AdvancedExternalizer<?>> getExternalizersFromProps() {
        HashMap map = new HashMap();
        String externalizers = this.property(Element.MARSHALLER, Element.EXTERNALIZERS);
        if (externalizers != null) {
            for (String ext : externalizers.split(",")) {
                String[] extArray = ext.split(":");
                String className = extArray.length > 1 ? extArray[1] : extArray[0];
                AdvancedExternalizer instance = (AdvancedExternalizer)Util.getInstance((String)className, (ClassLoader)this.classLoader);
                int id = extArray.length > 1 ? new Integer(extArray[0]) : instance.getId();
                map.put(id, instance);
            }
        }
        return map;
    }

    ConnectionFactoryConfiguration getConnectionConfig() {
        return this.connectionConfig;
    }

    DbMetaData getDbMeta() {
        return this.dbMetaData;
    }

    TableManipulationConfiguration getStringTable() {
        return this.stringTable;
    }

    TableManipulationConfiguration getBinaryTable() {
        return this.binaryTable;
    }

    JdbcStringBasedStoreConfigurationBuilder getJdbcConfigBuilder() {
        return this.jdbcConfigBuilder;
    }

    TwoWayKey2StringMapper getKey2StringMapper() {
        return this.key2StringMapper;
    }

    StreamingMarshaller getMarshaller() {
        return this.marshaller;
    }

    void addExternalizersToConfig(SerializationConfigurationBuilder builder) {
        if (this.externalizerMap == null) {
            return;
        }
        for (Map.Entry<Integer, AdvancedExternalizer<?>> entry : this.externalizerMap.entrySet()) {
            builder.addAdvancedExternalizer(entry.getKey().intValue(), entry.getValue());
        }
    }

    private String property(Element ... elements) {
        String key = this.propKey(elements);
        return this.properties.getProperty(key);
    }

    private String propKey(Element ... elements) {
        StringBuilder sb = new StringBuilder(this.orientation.toString().toLowerCase());
        sb.append(".");
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

