/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator;

import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.tools.jdbc.migrator.Element;
import org.infinispan.tools.jdbc.migrator.StoreType;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

class MigratorConfiguration {
    final String cacheName;
    final StoreType storeType;
    private final Properties props;
    private final boolean sourceStore;
    private final Element orientation;
    private DbMetaData dbMetaData;
    private TableManipulationConfiguration stringTable = null;
    private TableManipulationConfiguration binaryTable = null;
    private ConnectionFactoryConfiguration connectionConfig;
    private JdbcStringBasedStoreConfigurationBuilder jdbcConfigBuilder;
    private TwoWayKey2StringMapper key2StringMapper;
    private StreamingMarshaller marshaller;

    MigratorConfiguration(boolean sourceStore, Properties props) {
        this.props = props;
        this.sourceStore = sourceStore;
        this.orientation = sourceStore ? Element.SOURCE : Element.TARGET;
        this.cacheName = this.property(this.orientation, Element.CACHE_NAME);
        this.storeType = StoreType.valueOf(this.property(this.orientation, Element.TYPE).toUpperCase());
        this.initStoreConfig();
    }

    private void initStoreConfig() {
        if (this.cacheName == null) {
            String msg = String.format("The cache name property must be specified for the %1$s store. e.g. '%1$s.%2$s=some_cache'", new Object[]{this.orientation, Element.CACHE_NAME.toString()});
            throw new CacheConfigurationException(msg);
        }
        JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.dbMetaData = this.createDbMeta();
        this.connectionConfig = this.createConnectionConfig(builder);
        this.marshaller = this.createMarshaller();
        if (this.sourceStore) {
            if (this.storeType == StoreType.MIXED || this.storeType == StoreType.STRING) {
                this.stringTable = this.createTableConfig(Element.STRING, builder);
                this.key2StringMapper = this.createTwoWayMapper();
            }
            if (this.storeType == StoreType.MIXED || this.storeType == StoreType.BINARY) {
                this.binaryTable = this.createTableConfig(Element.BINARY, builder);
            }
        } else {
            this.key2StringMapper = this.createTwoWayMapper();
            builder.key2StringMapper(this.key2StringMapper.getClass());
            this.stringTable = this.createTableConfig(Element.STRING, builder);
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        }
        builder.validate();
        this.jdbcConfigBuilder = builder;
    }

    private DbMetaData createDbMeta() {
        DatabaseType type = DatabaseType.valueOf((String)this.property(this.orientation, Element.DIALECT).toUpperCase());
        String prop = this.property(Element.DB, Element.MAJOR_VERSION);
        int major = prop != null ? new Integer(prop) : -1;
        prop = this.property(Element.DB, Element.MINOR_VERSION);
        int minor = prop != null ? new Integer(prop) : -1;
        boolean upsert = Boolean.parseBoolean(this.property(Element.DB, Element.DISABLE_UPSERT));
        boolean indexing = Boolean.parseBoolean(this.property(Element.DB, Element.DISABLE_INDEXING));
        return new DbMetaData(type, Integer.valueOf(major), Integer.valueOf(minor), upsert, indexing);
    }

    private TableManipulationConfiguration createTableConfig(Element tableType, JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        boolean createOnStart = this.orientation == Element.TARGET;
        return ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)storeBuilder.table().createOnStart(createOnStart)).tableNamePrefix(this.property(this.orientation, Element.TABLE, tableType, Element.TABLE_NAME_PREFIX))).idColumnName(this.property(this.orientation, Element.TABLE, tableType, Element.ID, Element.NAME))).idColumnType(this.property(this.orientation, Element.TABLE, tableType, Element.ID, Element.TYPE))).dataColumnName(this.property(this.orientation, Element.TABLE, tableType, Element.DATA, Element.NAME))).dataColumnType(this.property(this.orientation, Element.TABLE, tableType, Element.DATA, Element.TYPE))).timestampColumnName(this.property(this.orientation, Element.TABLE, tableType, Element.TIMESTAMP, Element.NAME))).timestampColumnType(this.property(this.orientation, Element.TABLE, tableType, Element.TIMESTAMP, Element.TYPE))).create();
    }

    private PooledConnectionFactoryConfiguration createConnectionConfig(JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        return storeBuilder.connectionPool().connectionUrl(this.property(this.orientation, Element.CONNECTION_POOL, Element.CONNECTION_URL)).driverClass(this.property(this.orientation, Element.CONNECTION_POOL, Element.DRIVER_CLASS)).username(this.property(this.orientation, Element.CONNECTION_POOL, Element.USERNAME)).password(this.property(this.orientation, Element.CONNECTION_POOL, Element.PASSWORD)).create();
    }

    private TwoWayKey2StringMapper createTwoWayMapper() {
        String mapperClass = this.property(this.orientation, Element.KEY_TO_STRING_MAPPER);
        if (mapperClass != null) {
            ClassLoader classLoader = MigratorConfiguration.class.getClassLoader();
            try {
                return (TwoWayKey2StringMapper)Util.loadClass((String)mapperClass, (ClassLoader)classLoader).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException(String.format("Unabled to load TwoWayKey2StringMapper '%s' for %s store", new Object[]{mapperClass, this.orientation}), (Throwable)e);
            }
        }
        return new DefaultTwoWayKey2StringMapper();
    }

    private StreamingMarshaller createMarshaller() {
        String marshallerClass = this.property(this.orientation, Element.MARSHALLER);
        if (marshallerClass != null) {
            ClassLoader classLoader = MigratorConfiguration.class.getClassLoader();
            try {
                return (StreamingMarshaller)Util.loadClass((String)marshallerClass, (ClassLoader)classLoader).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException(String.format("Unabled to load StreamingMarshaller '%s' for %s store", new Object[]{marshallerClass, this.orientation}), (Throwable)e);
            }
        }
        return null;
    }

    ConnectionFactoryConfiguration getConnectionConfig() {
        return this.connectionConfig;
    }

    DbMetaData getDbMeta() {
        return this.dbMetaData;
    }

    TableManipulationConfiguration getStringTable() {
        return this.stringTable;
    }

    TableManipulationConfiguration getBinaryTable() {
        return this.binaryTable;
    }

    JdbcStringBasedStoreConfigurationBuilder getJdbcConfigBuilder() {
        return this.jdbcConfigBuilder;
    }

    TwoWayKey2StringMapper getKey2StringMapper() {
        return this.key2StringMapper;
    }

    boolean hasCustomMarshaller() {
        return this.marshaller != null;
    }

    StreamingMarshaller getMarshaller() {
        return this.marshaller;
    }

    void setMarshaller(StreamingMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    private String property(Element ... elements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return this.props.getProperty(sb.toString());
    }
}

