/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.infinispan.tools.doclet.config.XMLTreeOutputWalker;
import org.infinispan.tools.doclet.html.HtmlGenerator;
import org.infinispan.tools.schema.TreeNode;
import org.infinispan.tools.schema.XSOMSchemaTreeWalker;

public abstract class AbstractConfigHtmlGenerator
extends HtmlGenerator {
    protected static final String CONFIG_REF = "configRef";
    protected static final String CONFIG_REF_NAME_ATT = "name";
    protected static final String CONFIG_REF_PARENT_NAME_ATT = "parentName";
    protected static final String CONFIG_REF_DESC_ATT = "desc";
    private static final int LEVEL_MULT = 3;
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("infinispan.tools.configdoc.debug", "false"));
    protected RootDoc rootDoc;
    protected StringBuilder sb = new StringBuilder();

    public AbstractConfigHtmlGenerator(String encoding, String title, String bottom, String footer, String header, String metaDescription, List<String> metaKeywords) {
        super(encoding, title, bottom, footer, header, metaDescription, metaKeywords);
    }

    protected abstract List<Class<?>> getConfigBeans() throws Exception;

    protected abstract String getSchemaFile();

    protected abstract String getRootElementName();

    protected void preXMLTableOfContentsCreate(XSOMSchemaTreeWalker sw, XMLTreeOutputWalker tw) {
    }

    protected void postXMLTableOfContentsCreate(XSOMSchemaTreeWalker w, XMLTreeOutputWalker tw) {
    }

    protected boolean preVisitNode(TreeNode n) {
        return true;
    }

    protected boolean postVisitNode(TreeNode n) {
        return false;
    }

    protected String getTitle() {
        return "<h2>Configuration reference</h2><br/>";
    }

    public RootDoc getRootDoc() {
        return this.rootDoc;
    }

    public void setRootDoc(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
    }

    public InputStream lookupFile(String filename) {
        InputStream is;
        InputStream inputStream = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename);
        if (is == null) {
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return is;
    }

    protected InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl == null ? null : cl.getResourceAsStream(filename);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }

    protected StringBuilder getStringBuilder() {
        return this.sb;
    }

    @Override
    protected String generateContents() {
        this.sb.append(this.getTitle());
        try {
            List<Class<?>> configBeans = this.getConfigBeans();
            if (configBeans == null || configBeans.isEmpty()) {
                throw new Exception("Configuration bean classes are not specified. Make sure that getConfigBeans() method returns a list of classes. Documentation creation aborted");
            }
            XMLTreeOutputWalker tw = new XMLTreeOutputWalker(this.sb);
            String schemaFile = this.getSchemaFile();
            if (schemaFile == null) {
                throw new Exception("Schema file name not specified. Documentation creation aborted");
            }
            InputStream file = this.lookupFile(schemaFile);
            if (file == null) {
                throw new Exception("Schema file " + schemaFile + " not found on classpath. Documentation creation aborted");
            }
            XSOMParser reader = new XSOMParser();
            reader.parse(file);
            XSSchemaSet xss = reader.getResult();
            XSOMSchemaTreeWalker w = new XSOMSchemaTreeWalker(xss.getSchema(1), this.getRootElementName());
            TreeNode root = w.getRoot();
            this.associateBeansWithTreeNodes(configBeans, root);
            this.preXMLTableOfContentsCreate(w, tw);
            this.sb.append("<div class=\"source\"><pre>");
            tw.preOrderTraverse(root);
            this.sb.append("</pre></div>");
            this.postXMLTableOfContentsCreate(w, tw);
            for (TreeNode n : root) {
                boolean skip = this.preVisitNode(n);
                if (skip) continue;
                this.debug("element = " + n.getName(), 0);
                this.sb.append("<div class=\"section\">\n");
                this.generateHeaderForConfigurationElement(this.sb, tw, n);
                if (!n.getAttributes().isEmpty()) {
                    this.generateAttributeTableRows(this.sb, n);
                }
                boolean breakLoop = this.postVisitNode(n);
                this.sb.append("</div>\n");
                if (!breakLoop) continue;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Exception while generating configuration reference " + e);
            e.printStackTrace();
        }
        return this.sb.toString();
    }

    private void associateBeansWithTreeNodes(List<Class<?>> configBeans, TreeNode root) {
        for (TreeNode n : root) {
            if (n.getBeanClass() != null) continue;
            for (Class<?> clazz : configBeans) {
                ClassDoc classDoc = this.rootDoc.classNamed(clazz.getName());
                if (classDoc == null) continue;
                List<Tag> list = Arrays.asList(classDoc.tags(CONFIG_REF));
                for (Tag tag : list) {
                    String text = tag.text().trim();
                    Map<String, String> p = this.parseTag(text);
                    String thisNode = p.get(CONFIG_REF_NAME_ATT);
                    String parentNode = p.get(CONFIG_REF_PARENT_NAME_ATT);
                    if (!n.getName().equalsIgnoreCase(thisNode)) continue;
                    if (parentNode != null && parentNode.equalsIgnoreCase(n.getParent().getName())) {
                        n.setBeanClass(clazz);
                        continue;
                    }
                    if (parentNode != null) continue;
                    n.setBeanClass(clazz);
                }
            }
        }
    }

    private void generateAttributeTableRows(StringBuilder sb, TreeNode n) {
        sb.append("<table class=\"bodyTable\"> ");
        sb.append("<tr class=\"a\"><th>Attribute</th><th>Type</th><th>Default</th><th>Description</th></tr>\n");
        Class<?> bean = n.getBeanClass();
        Object object = null;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> c : constructors = bean.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != 0) continue;
                c.setAccessible(true);
                object = c.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            System.out.println("Did not construct object " + bean);
        }
        Set<XSAttributeDecl> attributes = n.getAttributes();
        for (XSAttributeDecl a : attributes) {
            sb.append("<tr class=\"b\">");
            sb.append("<td>").append("<code>" + a.getName() + "</code>").append("</td>\n");
            sb.append("<td>").append("<code>" + a.getType().getName() + "</code>");
            boolean isRestricted = false;
            XSRestrictionSimpleType restriction = a.getType().asRestriction();
            Collection declaredFacets = restriction.getDeclaredFacets();
            for (XSFacet facet : declaredFacets) {
                if (!facet.getName().equalsIgnoreCase("enumeration")) continue;
                isRestricted = true;
                break;
            }
            this.debug("attribute = " + a.getName() + "(restricted = " + isRestricted + ")", 1);
            if (isRestricted) {
                sb.append("* (");
                for (XSFacet facet : declaredFacets) {
                    sb.append(facet.getValue().toString() + '|');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")</td>\n");
            } else {
                sb.append("</td>\n");
            }
            if (a.getDefaultValue() != null) {
                this.debug("annotation-defined default = " + a.getDefaultValue(), 2);
                sb.append("<td>").append(a.getDefaultValue().toString()).append("</td>\n");
            } else {
                Field field = null;
                Object defaultValue = null;
                try {
                    field = this.findFieldRecursively(bean, a.getName());
                    defaultValue = AbstractConfigHtmlGenerator.fieldValue(field, object);
                    if (defaultValue != null) {
                        sb.append("<td>").append(defaultValue.toString()).append("</td>\n");
                        this.debug("field-defined default = " + defaultValue, 2);
                    } else {
                        this.debug("field-defined default is null!", 2);
                        sb.append("<td>").append("null").append("</td>\n");
                    }
                }
                catch (Exception e) {
                    this.debug("Caught exception, bean is " + bean.getName() + ", looking for field " + a.getName() + ", field " + field, 2);
                    e.printStackTrace();
                    sb.append("<td>").append("N/A").append("</td>\n");
                }
            }
            FieldDoc fieldDoc = this.findFieldDocRecursively(bean, a.getName(), CONFIG_REF);
            if (fieldDoc != null) {
                Tag[] tags = fieldDoc.tags(CONFIG_REF);
                Map<String, String> p = this.parseTag(tags[0].text().trim());
                sb.append("<td>").append(p.get(CONFIG_REF_DESC_ATT)).append("\n");
                String packageDir = fieldDoc.containingPackage().toString().replace(".", "/").concat("/");
                String htmlFile = fieldDoc.containingClass().typeName().concat(".html");
                String field = fieldDoc.name();
                sb.append(" (<a href=\"" + packageDir.concat(htmlFile).concat("#").concat(field) + "\">" + "Javadoc</a>)");
                sb.append("</td>\n");
            }
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
    }

    private void debug(String s, int level) {
        if (DEBUG) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < level * 3; ++i) {
                sb.append(" ");
            }
            sb.append("> ").append(s);
            System.out.println(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> parseTag(String tag) {
        HashMap<String, String> p = new HashMap<String, String>();
        Scanner sc = new Scanner(tag);
        Scanner sc2 = null;
        sc.useDelimiter("\"\\s*,\\s*");
        try {
            while (sc.hasNext()) {
                String keyValue = sc.next();
                sc2 = new Scanner(keyValue);
                sc2.useDelimiter("=\\s*\"");
                String key = sc2.next();
                String value = sc2.next().replace("\"", "");
                p.put(key, value);
                sc2.close();
            }
            sc.close();
        }
        catch (Exception e) {
            System.out.println("Invalid tag " + tag + " skipping...");
        }
        finally {
            sc.close();
            sc2.close();
        }
        return p;
    }

    private void generateHeaderForConfigurationElement(StringBuilder sb, XMLTreeOutputWalker tw, TreeNode n) {
        Tag[] tags;
        sb.append("<a name=\"").append("ce_" + n.getParent().getName() + "_" + n.getName() + "\">" + "</a>");
        sb.append("<h3><a name=\"" + n.getName() + "\"></a>" + n.getName() + "</h3>");
        sb.append("\n<p>");
        Class<?> beanClass = n.getBeanClass();
        ClassDoc classDoc = this.rootDoc.classNamed(beanClass.getName());
        for (Tag tag : tags = classDoc.tags(CONFIG_REF)) {
            String text = tag.text().trim();
            Map<String, String> m = this.parseTag(text);
            String name = m.get(CONFIG_REF_NAME_ATT);
            if (!n.getName().equals(name)) continue;
            sb.append(m.get(CONFIG_REF_DESC_ATT));
        }
        sb.append("<BR/><BR />");
        if (n.getParent().getParent() != null) {
            sb.append("The parent element is <a href=\"").append("#ce_" + n.getParent().getParent().getName() + "_" + n.getParent().getName() + "\">" + "&lt;" + n.getParent().getName() + "&gt;" + "</a>.  ");
        }
        if (!n.getChildren().isEmpty()) {
            int childCount = n.getChildren().size();
            int count = 1;
            if (childCount == 1) {
                sb.append("The only child element is ");
            } else {
                sb.append("Child elements are ");
            }
            for (TreeNode tn : n.getChildren()) {
                sb.append("<a href=\"").append("#ce_" + tn.getParent().getName() + "_" + tn.getName() + "\">" + "&lt;" + tn.getName() + "&gt;" + "</a>");
                if (count < childCount) {
                    sb.append(", ");
                } else {
                    sb.append(".");
                }
                ++count;
            }
            sb.append("\n");
        }
        sb.append("</p>");
    }

    private Field findFieldRecursively(Class<?> c, String fieldName) {
        Field f;
        block2: while (true) {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                ClassDoc classDoc = this.rootDoc.classNamed(c.getName());
                for (FieldDoc fd : classDoc.fields()) {
                    for (Tag t : fd.tags(CONFIG_REF)) {
                        Map<String, String> m = this.parseTag(t.text().trim());
                        String field = m.get(CONFIG_REF_NAME_ATT);
                        if (field == null || !field.startsWith(fieldName)) continue;
                        fieldName = fd.name();
                        continue block2;
                    }
                }
                if (c.equals(Object.class)) break;
                f = this.findFieldRecursively(c.getSuperclass(), fieldName);
            }
            break;
        }
        return f;
    }

    private FieldDoc findFieldDocRecursively(Class<?> c, String fieldName, String tagName) {
        while (true) {
            ClassDoc classDoc = this.rootDoc.classNamed(c.getName());
            for (FieldDoc fd : classDoc.fields()) {
                if (fd.name().equalsIgnoreCase(fieldName)) {
                    return fd;
                }
                for (Tag t : fd.tags(tagName)) {
                    String value;
                    Map<String, String> m = this.parseTag(t.text().trim());
                    if (!m.containsKey(CONFIG_REF_NAME_ATT) || !fieldName.equalsIgnoreCase(value = m.get(CONFIG_REF_NAME_ATT).trim())) continue;
                    return fd;
                }
            }
            if (c.getSuperclass() == null) break;
            c = c.getSuperclass();
        }
        return null;
    }

    private static Object fieldValue(Field field, Object target) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not get field " + field, iae);
        }
    }
}

