/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.schema;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.Iterator;
import org.infinispan.tools.schema.TreeNode;

public class XSOMSchemaTreeWalker
implements XSVisitor {
    private XSSchema schema;
    TreeNode root;
    TreeNode currentNode;

    public XSOMSchemaTreeWalker(XSSchema schema, String rootName) {
        this.schema = schema;
        XSElementDecl decl = schema.getElementDecl(rootName);
        XSComplexType type = schema.getComplexType(decl.getType().getName());
        this.root = new TreeNode("infinispan", new TreeNode());
        this.root.setType(type);
        this.currentNode = this.root;
        this.complexType(type);
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void empty(XSContentType empty) {
    }

    public void particle(XSParticle part) {
        StringBuffer buf = new StringBuffer();
        int i = part.getMaxOccurs();
        if (i == -1) {
            buf.append(" maxOccurs=\"unbounded\"");
        } else if (i != 1) {
            buf.append(" maxOccurs=\"" + i + "\"");
        }
        i = part.getMinOccurs();
        if (i != 1) {
            buf.append(" minOccurs=\"" + i + "\"");
        }
        part.getTerm().visit(new XSTermVisitor(){

            public void elementDecl(XSElementDecl decl) {
                if (decl.isLocal()) {
                    XSOMSchemaTreeWalker.this.elementDecl(decl);
                }
            }

            public void modelGroupDecl(XSModelGroupDecl decl) {
            }

            public void modelGroup(XSModelGroup group) {
                int len = group.getSize();
                for (int i = 0; i < len; ++i) {
                    XSOMSchemaTreeWalker.this.particle(group.getChild(i));
                }
            }

            public void wildcard(XSWildcard wc) {
            }
        });
    }

    public void simpleType(XSSimpleType simpleType) {
        simpleType.visit(new XSSimpleTypeVisitor(){

            public void listSimpleType(XSListSimpleType type) {
            }

            public void restrictionSimpleType(XSRestrictionSimpleType type) {
                XSSimpleType baseType = type.getSimpleBaseType();
                Iterator itr = type.iterateDeclaredFacets();
                while (itr.hasNext()) {
                    XSOMSchemaTreeWalker.this.facet((XSFacet)itr.next());
                }
            }

            public void unionSimpleType(XSUnionSimpleType type) {
            }
        });
    }

    public void annotation(XSAnnotation ann) {
    }

    public void attGroupDecl(XSAttGroupDecl decl) {
    }

    public void attributeDecl(XSAttributeDecl decl) {
    }

    public void attributeUse(XSAttributeUse use) {
        XSAttributeDecl decl = use.getDecl();
        if (decl.isLocal()) {
            this.visitAttribute(decl);
        }
    }

    private void visitAttribute(XSAttributeDecl decl) {
        XSSimpleType type = decl.getType();
        this.currentNode.addAttribute(decl);
        if (this.schema.getSimpleType(type.getName()) != null) {
            this.simpleType(type);
        }
    }

    private void dumpComplexTypeAttribute(XSComplexType type) {
        Iterator itr = type.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            this.attributeUse((XSAttributeUse)itr.next());
        }
    }

    public void complexType(XSComplexType type) {
        this.dumpComplexTypeAttribute(type);
        if (type.getDerivationMethod() == 2) {
            type.getContentType().visit((XSVisitor)this);
        } else {
            XSType baseType = type.getBaseType();
            String name = baseType.getName();
            XSComplexType parentType = this.schema.getComplexType(name);
            this.complexType(parentType);
            type.getExplicitContent().visit((XSVisitor)this);
        }
    }

    public void facet(XSFacet facet) {
    }

    public void identityConstraint(XSIdentityConstraint decl) {
    }

    public void notation(XSNotation notation) {
    }

    public void schema(XSSchema schema) {
    }

    public void xpath(XSXPath xp) {
    }

    public void elementDecl(XSElementDecl decl) {
        XSComplexType type = this.schema.getComplexType(decl.getType().getName());
        if (!decl.isAbstract()) {
            TreeNode n = new TreeNode(decl.getName(), this.currentNode);
            this.currentNode.getChildren().add(n);
            this.currentNode = n;
            this.currentNode.setType(type);
            this.complexType(type);
            this.currentNode = n.getParent();
        }
    }

    public void modelGroup(XSModelGroup group) {
    }

    public void modelGroupDecl(XSModelGroupDecl decl) {
    }

    public void wildcard(XSWildcard wc) {
    }
}

