/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.infinispan.tools.doclet.config.ConfigHtmlGenerator;

public class ConfigDoclet {
    static String outputDirectory = ".";
    static String header;
    static String footer;
    static String encoding;
    static String title;
    static String bottom;
    static String cp;

    public static boolean start(RootDoc root) throws IOException {
        System.out.println("STARTING CONFIG DOCLET");
        ConfigHtmlGenerator generator = new ConfigHtmlGenerator(encoding, ConfigDoclet.title(), bottom, footer, header, "Infinispan configuration options", Arrays.asList("Configuration", "Infinispan", "Data Grids", "Documentation", "Reference", "MBeans"), cp);
        generator.setRootDoc(root);
        generator.generateHtml(outputDirectory + File.separator + "config.html", "stylesheet2.css");
        System.out.println("FINISHING CONFIG DOCLET");
        return true;
    }

    private static String title() {
        String s = "Configuration options";
        if (title == null || title.equals("")) {
            return s;
        }
        s = s + " (" + title + ")";
        return s;
    }

    public static int optionLength(String option) {
        return ConfigurationImpl.getInstance().optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        for (String[] option : options) {
            if (option[0].equals("-d")) {
                outputDirectory = option[1];
                continue;
            }
            if (option[0].equals("-encoding")) {
                encoding = option[1];
                continue;
            }
            if (option[0].equals("-bottom")) {
                bottom = option[1];
                continue;
            }
            if (option[0].equals("-footer")) {
                footer = option[1];
                continue;
            }
            if (option[0].equals("-header")) {
                header = option[1];
                continue;
            }
            if (option[0].equals("-doctitle")) {
                title = option[1];
                continue;
            }
            if (!option[0].equals("-classpath")) continue;
            cp = option[1];
        }
        return ConfigurationImpl.getInstance().validOptions(options, reporter);
    }
}

