/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.schema;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ConfigurationProperties;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.config.parsing.TreeNode;
import org.infinispan.config.parsing.TreeWalker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationTreeWalker
implements TreeWalker {
    protected final Log log = LogFactory.getLog(this.getClass());

    public TreeNode constructTreeFromBeans(List<Class<?>> configBeans) {
        ArrayList<ConfigurationElement> lce = new ArrayList<ConfigurationElement>(7);
        for (Class<?> clazz : configBeans) {
            ConfigurationElement[] ces = null;
            ConfigurationElements configurationElements = clazz.getAnnotation(ConfigurationElements.class);
            ConfigurationElement configurationElement = clazz.getAnnotation(ConfigurationElement.class);
            if (configurationElement != null && configurationElements == null) {
                ces = new ConfigurationElement[]{configurationElement};
            }
            if (configurationElements != null && configurationElement == null) {
                ces = configurationElements.elements();
            }
            if (ces == null) continue;
            lce.addAll(Arrays.asList(ces));
        }
        TreeNode root = new TreeNode("infinispan", new TreeNode(), 0);
        this.makeTree(lce, root, 1);
        return root;
    }

    private void makeTree(List<ConfigurationElement> lce, TreeNode tn, int currentDepth) {
        for (ConfigurationElement ce : lce) {
            if (!ce.parent().equals(tn.getName())) continue;
            TreeNode child = new TreeNode(ce.name(), tn, currentDepth);
            tn.getChildren().add(child);
            this.makeTree(lce, child, currentDepth + 1);
        }
    }

    public void levelOrderTraverse(TreeNode root) {
        LinkedBlockingQueue<TreeNode> q = new LinkedBlockingQueue<TreeNode>();
        q.add(root);
        while (!q.isEmpty()) {
            TreeNode treeNode = (TreeNode)q.poll();
            treeNode.accept((TreeWalker)this);
            if (!treeNode.hasChildren()) continue;
            q.addAll(treeNode.getChildren());
        }
    }

    public void preOrderTraverse(TreeNode node) {
        node.accept((TreeWalker)this);
        if (node.hasChildren()) {
            for (TreeNode child : node.getChildren()) {
                this.preOrderTraverse(child);
            }
        }
    }

    public void postOrderTraverse(TreeNode node) {
        if (node.hasChildren()) {
            for (TreeNode child : node.getChildren()) {
                this.preOrderTraverse(child);
            }
        }
        node.accept((TreeWalker)this);
    }

    public void postTraverseCleanup() {
    }

    protected ConfigurationElement findConfigurationElementForBean(Class<?> clazz, String name, String parentName) {
        ConfigurationElement[] onBean;
        for (ConfigurationElement ce : onBean = this.configurationElementsOnBean(clazz)) {
            if (!ce.name().equals(name) || !ce.parent().equals(parentName)) continue;
            return ce;
        }
        return null;
    }

    protected ConfigurationElement findConfigurationElement(List<Class<?>> b, String name, String parentName) {
        ConfigurationElement result = null;
        Class<?> bean = this.findBean(b, name, parentName);
        if (bean != null) {
            result = this.findConfigurationElementForBean(bean, name, parentName);
        }
        return result;
    }

    protected ConfigurationElement[] configurationElementsOnBean(Class<?> clazz) {
        ConfigurationElements configurationElements = clazz.getAnnotation(ConfigurationElements.class);
        ConfigurationElement configurationElement = clazz.getAnnotation(ConfigurationElement.class);
        ConfigurationElement[] ces = new ConfigurationElement[]{};
        if (configurationElement != null && configurationElements == null) {
            ces = new ConfigurationElement[]{configurationElement};
        }
        if (configurationElements != null && configurationElement == null) {
            ces = configurationElements.elements();
        }
        return ces;
    }

    protected ConfigurationProperty[] propertiesElementsOnMethod(Method m) {
        ConfigurationProperty[] cprops = new ConfigurationProperty[]{};
        ConfigurationProperties cp = m.getAnnotation(ConfigurationProperties.class);
        ConfigurationProperty p = null;
        if (cp != null) {
            cprops = cp.elements();
        } else {
            p = m.getAnnotation(ConfigurationProperty.class);
            if (p != null) {
                cprops = new ConfigurationProperty[]{p};
            }
        }
        return cprops;
    }

    protected Class<?> findBean(List<Class<?>> b, String name, String parentName) throws ConfigurationException {
        if (parentName.equals("namedCache")) {
            parentName = "default";
        }
        for (Class<?> clazz : b) {
            ConfigurationElements elements = clazz.getAnnotation(ConfigurationElements.class);
            try {
                if (elements != null) {
                    for (ConfigurationElement ce : elements.elements()) {
                        if (!ce.name().equals(name) || !ce.parent().equals(parentName)) continue;
                        return clazz;
                    }
                    continue;
                }
                ConfigurationElement ce = clazz.getAnnotation(ConfigurationElement.class);
                if (ce == null || !ce.name().equals(name) || !ce.parent().equals(parentName)) continue;
                return clazz;
            }
            catch (Exception e1) {
                throw new ConfigurationException("Could not instantiate class " + clazz, (Throwable)e1);
            }
        }
        return null;
    }
}

