/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationProperties;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.tools.doclet.html.HtmlGenerator;
import org.infinispan.util.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHtmlGenerator
extends HtmlGenerator {
    String classpath;

    public ConfigHtmlGenerator(String encoding, String title, String bottom, String footer, String header, String metaDescription, List<String> metaKeywords, String classpath) {
        super(encoding, title, bottom, footer, header, metaDescription, metaKeywords);
        this.classpath = classpath;
    }

    protected List<Class<?>> getConfigBeans() throws Exception {
        return ClassFinder.isAssignableFrom((List)ClassFinder.infinispanClasses((String)this.classpath), AbstractConfigurationBean.class);
    }

    @Override
    protected String generateContents() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Infinispan configuration options</h2><br/>");
        sb.append("<UL>");
        try {
            List<Class<?>> configBeans = this.getConfigBeans();
            TreeNode root = this.tree(configBeans);
            sb.append("<div class=\"source\"><pre>");
            sb.append(root.pp(""));
            sb.append("</pre></div>");
            this.tree(configBeans);
            for (Class<?> clazz : configBeans) {
                ConfigurationElement[] ces = null;
                ConfigurationElements configurationElements = clazz.getAnnotation(ConfigurationElements.class);
                ConfigurationElement configurationElement = clazz.getAnnotation(ConfigurationElement.class);
                if (configurationElement != null && configurationElements == null) {
                    ces = new ConfigurationElement[]{configurationElement};
                }
                if (configurationElements != null && configurationElement == null) {
                    ces = configurationElements.elements();
                }
                if (ces == null) continue;
                for (ConfigurationElement ce : ces) {
                    boolean createdAttributes = false;
                    boolean createdProperties = false;
                    sb.append("\n<a name=\"").append("ce_" + ce.parent() + "_" + ce.name() + "\">" + "</a>");
                    sb.append("<div class=\"section\"><h3><a name=\"" + ce.name() + "\"></a>" + ce.name() + "</h3>");
                    sb.append("\n<p>");
                    if (ce.description().length() > 0) {
                        sb.append(ce.description());
                    } else {
                        sb.append("todo");
                    }
                    TreeNode n = this.findNode(root, ce.name(), ce.parent());
                    sb.append(" Parent element is <a href=\"").append("#ce_" + n.parent.parent.name + "_" + n.parent.name + "\">" + "&lt;" + ce.parent() + "&gt;" + "</a>.");
                    if (n != null && !n.children.isEmpty()) {
                        sb.append(" Child elements are ");
                        int childCount = n.children.size();
                        int count = 1;
                        for (TreeNode tn : n.children) {
                            sb.append("<a href=\"").append("#ce_" + tn.parent.name + "_" + tn.name + "\">" + "&lt;" + tn.name + "&gt;" + "</a>");
                            if (count < childCount) {
                                sb.append(",");
                            } else {
                                sb.append(".");
                            }
                            ++count;
                        }
                        sb.append("\n");
                    }
                    sb.append("</p>");
                    for (Method m : clazz.getMethods()) {
                        boolean childElement;
                        ConfigurationAttribute a = m.getAnnotation(ConfigurationAttribute.class);
                        boolean bl = childElement = a != null && a.containingElement().equals(ce.name());
                        if (childElement && !createdAttributes) {
                            sb.append("<table class=\"bodyTable\"> ");
                            sb.append("<tr class=\"a\"><th>Attribute</th><th>Type</th><th>Default</th><th>Description</th></tr>\n");
                            createdAttributes = true;
                        }
                        if (!childElement) continue;
                        sb.append("<tr class=\"b\">");
                        sb.append("<td>").append("<code>" + a.name() + "</code>").append("</td>\n");
                        if (a.allowedValues().length() > 0) {
                            sb.append("<td>").append("<code>" + a.allowedValues() + "</code>").append("</td>\n");
                        } else if (this.isSetterMethod(m)) {
                            sb.append("<td>").append("<code>" + m.getParameterTypes()[0].getSimpleName() + "</code>").append("</td>\n");
                        }
                        if (a.defaultValue().length() > 0) {
                            sb.append("<td>").append(a.defaultValue()).append("</td>\n");
                        } else {
                            try {
                                Object matchingFieldValue = this.matchingFieldValue(m);
                                sb.append("<td>").append(matchingFieldValue).append("</td>\n");
                            }
                            catch (Exception e) {
                                sb.append("<td>").append("N/A").append("</td>\n");
                            }
                        }
                        if (a.description().length() > 0) {
                            sb.append("<td>").append(a.description()).append("</td>\n");
                        } else {
                            sb.append("<td>").append("todo").append("</td>\n");
                        }
                        sb.append("</tr>\n");
                    }
                    if (createdAttributes) {
                        sb.append("</table></div>");
                    }
                    for (Method m : clazz.getMethods()) {
                        ConfigurationProperty[] cprops = null;
                        ConfigurationProperties cp = m.getAnnotation(ConfigurationProperties.class);
                        ConfigurationProperty p = null;
                        if (cp != null) {
                            cprops = cp.elements();
                        } else {
                            p = m.getAnnotation(ConfigurationProperty.class);
                            if (p != null) {
                                cprops = new ConfigurationProperty[]{p};
                            }
                        }
                        if (cprops == null) continue;
                        for (ConfigurationProperty c : cprops) {
                            boolean child = c.parentElement().equals(ce.name());
                            if (child && !createdProperties) {
                                sb.append("\n<table class=\"bodyTable\"> ");
                                sb.append("<tr class=\"a\"><th>Property</th><th>Description</th></tr>\n");
                                createdProperties = true;
                            }
                            if (!child) continue;
                            sb.append("<tr class=\"b\">");
                            sb.append("<td>").append(c.name()).append("</td>\n");
                            if (c.description().length() > 0) {
                                sb.append("<td>").append(c.description()).append("</td>\n");
                            } else {
                                sb.append("<td>").append("todo").append("</td>\n");
                            }
                            sb.append("</tr>\n");
                        }
                    }
                    if (!createdProperties) continue;
                    sb.append("</table></div>");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private TreeNode findNode(TreeNode tn, String name, String parent) {
        TreeNode result = null;
        if (tn.name.equals(name) && tn.parent != null && tn.parent.name.equals(parent)) {
            result = tn;
        } else {
            TreeNode child;
            Iterator<TreeNode> i$ = tn.children.iterator();
            while (i$.hasNext() && (result = this.findNode(child = i$.next(), name, parent)) == null) {
            }
        }
        return result;
    }

    private TreeNode tree(List<Class<?>> configBeans) {
        ArrayList<ConfigurationElement> lce = new ArrayList<ConfigurationElement>(7);
        for (Class<?> clazz : configBeans) {
            ConfigurationElement[] ces = null;
            ConfigurationElements configurationElements = clazz.getAnnotation(ConfigurationElements.class);
            ConfigurationElement configurationElement = clazz.getAnnotation(ConfigurationElement.class);
            if (configurationElement != null && configurationElements == null) {
                ces = new ConfigurationElement[]{configurationElement};
            }
            if (configurationElements != null && configurationElement == null) {
                ces = configurationElements.elements();
            }
            if (ces == null) continue;
            lce.addAll(Arrays.asList(ces));
        }
        TreeNode root = new TreeNode();
        root.parent = new TreeNode();
        root.name = "infinispan";
        this.makeTree(lce, root);
        return root;
    }

    private void makeTree(List<ConfigurationElement> lce, TreeNode tn) {
        for (ConfigurationElement ce : lce) {
            if (!ce.parent().equals(tn.name)) continue;
            TreeNode child = new TreeNode();
            child.name = ce.name();
            child.parent = tn;
            tn.children.add(child);
            this.makeTree(lce, child);
        }
    }

    private boolean isSetterMethod(Method m) {
        return m.getName().startsWith("set") && m.getParameterTypes().length == 1;
    }

    private Object matchingFieldValue(Method m) throws Exception {
        String name = m.getName();
        if (!name.startsWith("set")) {
            throw new IllegalArgumentException("Not a setter method");
        }
        String fieldName = name.substring(name.indexOf("set") + 3);
        fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        Field f = m.getDeclaringClass().getDeclaredField(fieldName);
        return ConfigHtmlGenerator.getField(f, m.getDeclaringClass().newInstance());
    }

    private static Object getField(Field field, Object target) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not get field " + field, iae);
        }
    }

    private class TreeNode {
        String name = "";
        TreeNode parent;
        Set<TreeNode> children = new HashSet<TreeNode>();

        private TreeNode() {
        }

        public String toString() {
            return this.name;
        }

        public String pp(String prefix) {
            StringBuffer result = new StringBuffer(prefix + "&lt;<a href=\"" + "#ce_" + this.parent.name + "_" + this.name + "\">" + this.name + "</a>&gt;" + "\n");
            String newPrefix = prefix + "  ";
            for (TreeNode child : this.children) {
                result.append(child.pp(newPrefix));
            }
            return result.toString();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof TreeNode)) {
                return false;
            }
            TreeNode tn = (TreeNode)other;
            return this.parent.name != null && tn.parent != null && this.parent.name.equals(tn.parent.name) && this.name.equals(tn.name);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.parent != null && this.parent.name != null ? this.parent.name.hashCode() : 0);
            return result;
        }
    }
}

