/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;

public class SoftIndexFileStoreIterator
implements StoreIterator {
    private final MarshallableEntryFactory<?, ?> entryFactory;
    private final Path location;
    private final int majorVersion;

    public SoftIndexFileStoreIterator(StoreProperties props) {
        props.required(Element.LOCATION);
        String location = props.get(Element.LOCATION);
        File file = new File(location);
        if (!file.exists() || !file.isDirectory()) {
            throw new CacheException(String.format("Unable to read directory at '%s'", location));
        }
        this.location = Paths.get(location, new String[0]);
        this.entryFactory = SerializationConfigUtil.getEntryFactory(props);
        this.majorVersion = props.getMajorVersion();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterator<MarshallableEntry> iterator() {
        return new SoftIndexIterator();
    }

    class SoftIndexIterator
    implements Iterator<MarshallableEntry> {
        final FileProvider fileProvider;
        final Iterator<Integer> iterator;
        final HeaderReader reader;
        FileProvider.Handle handle;
        int file = -1;
        int offset = 0;

        SoftIndexIterator() {
            if (SoftIndexFileStoreIterator.this.majorVersion < 11) {
                this.fileProvider = new FileProvider(SoftIndexFileStoreIterator.this.location, 1000, "", 0x100000);
                this.reader = EntryRecord::read10_1EntryHeader;
            } else {
                String prefix = SoftIndexFileStoreIterator.this.majorVersion == 11 ? "ispn." : "ispn12.";
                this.fileProvider = new FileProvider(SoftIndexFileStoreIterator.this.location, 1000, prefix, 0x100000);
                this.reader = EntryRecord::readEntryHeader;
            }
            this.iterator = this.fileProvider.getFileIterator();
        }

        @Override
        public boolean hasNext() {
            return this.file > -1 || this.iterator.hasNext();
        }

        @Override
        public MarshallableEntry next() {
            try {
                block2: while (this.hasNext()) {
                    if (this.file < 0) {
                        this.file = this.iterator.next();
                        this.handle = this.fileProvider.getFile(this.file);
                    }
                    while (true) {
                        EntryHeader header;
                        if ((header = this.reader.read(this.handle, this.offset)) == null) {
                            this.handle.close();
                            this.file = -1;
                            continue block2;
                        }
                        if (header.valueLength() > 0) {
                            byte[] serializedKey = EntryRecord.readKey((FileProvider.Handle)this.handle, (EntryHeader)header, (long)this.offset);
                            byte[] serializedValue = EntryRecord.readValue((FileProvider.Handle)this.handle, (EntryHeader)header, (long)this.offset);
                            this.offset += header.totalLength();
                            if (this.reader.read(this.handle, this.offset) == null) {
                                this.handle.close();
                                this.file = -1;
                            }
                            return SoftIndexFileStoreIterator.this.entryFactory.create((ByteBuffer)ByteBufferImpl.create((byte[])serializedKey), (ByteBuffer)ByteBufferImpl.create((byte[])serializedValue));
                        }
                        this.offset += header.totalLength();
                    }
                }
                throw new NoSuchElementException();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    private static interface HeaderReader {
        public EntryHeader read(FileProvider.Handle var1, int var2) throws IOException;
    }
}

