/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.marshall.core.Ids;

public class TransientMortalCacheEntryExternalizer
implements AdvancedExternalizer<TransientMortalCacheEntry> {
    public Set<Class<? extends TransientMortalCacheEntry>> getTypeClasses() {
        return Collections.singleton(TransientMortalCacheEntry.class);
    }

    public Integer getId() {
        return Ids.TRANSIENT_MORTAL_ENTRY;
    }

    public void writeObject(ObjectOutput output, TransientMortalCacheEntry ice) throws IOException {
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)ice.getCreated());
        output.writeLong(ice.getLifespan());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)ice.getLastUsed());
        output.writeLong(ice.getMaxIdle());
    }

    public TransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        Object value = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long lifespan = input.readLong();
        long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long maxIdle = input.readLong();
        return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
    }
}

