/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.marshall.core.Ids;

public class TransientCacheEntryExternalizer
implements AdvancedExternalizer<TransientCacheEntry> {
    public Set<Class<? extends TransientCacheEntry>> getTypeClasses() {
        return Collections.singleton(TransientCacheEntry.class);
    }

    public Integer getId() {
        return Ids.TRANSIENT_ENTRY;
    }

    public void writeObject(ObjectOutput output, TransientCacheEntry ice) throws IOException {
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)ice.getLastUsed());
        output.writeLong(ice.getMaxIdle());
    }

    public TransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        Object value = input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long maxIdle = input.readLong();
        return new TransientCacheEntry(key, value, maxIdle, lastUsed);
    }
}

