/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.rocksdb;

import java.io.File;
import java.util.Iterator;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDBReader
implements StoreIterator {
    private final RocksDB db;
    private final StreamingMarshaller marshaller;

    public RocksDBReader(StoreProperties props) {
        props.required(Element.LOCATION);
        String location = props.get(Element.LOCATION) + props.get(Element.CACHE_NAME).replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        File f = new File(location);
        if (!f.exists() || !f.isDirectory()) {
            throw new CacheException(String.format("Unable to read db directory '%s'", location));
        }
        Options options = new Options().setCreateIfMissing(false);
        String compressionType = props.get(Element.COMPRESSION);
        if (compressionType != null) {
            options.setCompressionType(CompressionType.getCompressionType((String)compressionType));
        }
        try {
            this.db = RocksDB.openReadOnly((Options)options, (String)location);
        }
        catch (RocksDBException e) {
            throw new CacheException((Throwable)e);
        }
        this.marshaller = SerializationConfigUtil.getMarshaller(props);
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    public Iterator<MarshallableEntry> iterator() {
        return new RocksDBIterator();
    }

    class RocksDBIterator
    implements Iterator<MarshallableEntry>,
    AutoCloseable {
        final RocksIterator it;

        private RocksDBIterator() {
            this.it = RocksDBReader.this.db.newIterator(new ReadOptions().setFillCache(false));
            this.it.seekToFirst();
        }

        @Override
        public void close() {
            this.it.close();
        }

        @Override
        public boolean hasNext() {
            return this.it.isValid();
        }

        @Override
        public MarshallableEntry next() {
            MarshallableEntry entry = (MarshallableEntry)this.unmarshall(this.it.value());
            this.it.next();
            return entry;
        }

        private <T> T unmarshall(byte[] bytes) {
            try {
                return (T)RocksDBReader.this.marshaller.objectFromByteBuffer(bytes);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }
}

