/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.io.FileReader;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreIteratorFactory;
import org.infinispan.tools.store.migrator.TargetStoreFactory;

public class StoreMigrator {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private final Properties properties;

    public StoreMigrator(Properties properties) {
        this.properties = properties;
    }

    public void run() throws Exception {
        String batchSizeProp = this.properties.getProperty((Object)((Object)Element.BATCH) + "." + (Object)((Object)Element.SIZE));
        int batchLimit = batchSizeProp != null ? new Integer(batchSizeProp) : 1;
        try (EmbeddedCacheManager manager = TargetStoreFactory.getCacheManager(this.properties);
             StoreIterator sourceReader = StoreIteratorFactory.get(this.properties);){
            AdvancedCache targetCache = TargetStoreFactory.getTargetCache(manager, this.properties);
            TransactionManager tm = targetCache.getTransactionManager();
            int txBatchSize = 0;
            for (MarshallableEntry entry : sourceReader) {
                if (txBatchSize == 0) {
                    tm.begin();
                }
                targetCache.put(entry.getKey(), entry.getValue());
                if (++txBatchSize != batchLimit) continue;
                txBatchSize = 0;
                tm.commit();
            }
            if (tm.getStatus() == 0) {
                tm.commit();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: StoreMigrator migrator.properties");
            System.exit(1);
        }
        Properties properties = new Properties();
        properties.load(new FileReader(args[0]));
        new StoreMigrator(properties).run();
    }
}

