/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.tools.store.migrator.jdbc.AbstractJdbcEntryIterator;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;
import org.infinispan.util.KeyValuePair;

class StringJdbcIterator
extends AbstractJdbcEntryIterator {
    private final TwoWayKey2StringMapper key2StringMapper;
    private final MarshallableEntryFactory entryFactory;

    StringJdbcIterator(ConnectionFactory connectionFactory, TableManager tableManager, StreamingMarshaller marshaller, TwoWayKey2StringMapper key2StringMapper) {
        super(connectionFactory, tableManager, marshaller);
        this.key2StringMapper = key2StringMapper;
        this.entryFactory = SerializationConfigUtil.getEntryFactory((Marshaller)marshaller);
    }

    @Override
    public boolean hasNext() {
        return this.rowIndex < this.numberOfRows;
    }

    @Override
    public MarshallableEntry next() {
        try {
            if (this.rs.next()) {
                ++this.rowIndex;
                Object key = this.key2StringMapper.getKeyMapping(this.rs.getString(2));
                KeyValuePair<ByteBuffer, ByteBuffer> icv = this.unmarshall(this.rs.getBinaryStream(1));
                return this.entryFactory.create(key, (ByteBuffer)icv.getKey(), (ByteBuffer)icv.getValue());
            }
            this.close();
            throw new NoSuchElementException();
        }
        catch (SQLException e) {
            throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
        }
    }

    private KeyValuePair<ByteBuffer, ByteBuffer> unmarshall(InputStream inputStream) throws PersistenceException {
        try {
            return (KeyValuePair)this.marshaller.objectFromInputStream(inputStream);
        }
        catch (IOException e) {
            throw new PersistenceException("I/O error while unmarshalling from stream", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

