/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.file;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;

public class SoftIndexFileStoreIterator
implements StoreIterator {
    private final StreamingMarshaller marshaller;
    private final String location;

    public SoftIndexFileStoreIterator(StoreProperties props) {
        props.required(Element.LOCATION);
        String location = props.get(Element.LOCATION);
        File file = new File(location);
        if (!file.exists() || !file.isDirectory()) {
            throw new CacheException(String.format("Unable to read directory at '%s'", location));
        }
        this.location = location;
        this.marshaller = SerializationConfigUtil.getMarshaller(props);
    }

    @Override
    public void close() {
    }

    @Override
    public Iterator<MarshalledEntry> iterator() {
        return new SoftIndexIterator(this.location);
    }

    class SoftIndexIterator
    implements Iterator<MarshalledEntry> {
        final FileProvider fileProvider;
        final Iterator<Integer> iterator;
        FileProvider.Handle handle;
        int file = -1;
        int offset = 0;

        SoftIndexIterator(String location) {
            this.fileProvider = new FileProvider(location, 1000);
            this.iterator = this.fileProvider.getFileIterator();
        }

        @Override
        public boolean hasNext() {
            return this.file > -1 || this.iterator.hasNext();
        }

        @Override
        public MarshalledEntry next() {
            try {
                block2: while (this.hasNext()) {
                    if (this.file < 0) {
                        this.file = this.iterator.next();
                        this.handle = this.fileProvider.getFile(this.file);
                    }
                    while (true) {
                        EntryHeader header;
                        if ((header = EntryRecord.readEntryHeader((FileProvider.Handle)this.handle, (long)this.offset)) == null) {
                            this.handle.close();
                            this.file = -1;
                            continue block2;
                        }
                        if (header.valueLength() > 0) {
                            byte[] serializedKey = EntryRecord.readKey((FileProvider.Handle)this.handle, (EntryHeader)header, (long)this.offset);
                            byte[] serializedValue = EntryRecord.readValue((FileProvider.Handle)this.handle, (EntryHeader)header, (long)this.offset);
                            Object key = SoftIndexFileStoreIterator.this.marshaller.objectFromByteBuffer(serializedKey);
                            Object value = SoftIndexFileStoreIterator.this.marshaller.objectFromByteBuffer(serializedValue);
                            this.offset += header.totalLength();
                            if (EntryRecord.readEntryHeader((FileProvider.Handle)this.handle, (long)this.offset) == null) {
                                this.handle.close();
                                this.file = -1;
                            }
                            return new MarshalledEntryImpl(key, value, null, SoftIndexFileStoreIterator.this.marshaller);
                        }
                        this.offset += header.totalLength();
                    }
                }
                throw new NoSuchElementException();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }
}

