/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.config.v6;

import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParsedCacheMode;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.persistence.cluster.ClusterLoader;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.tools.config.v6.Attribute;
import org.infinispan.tools.config.v6.Element;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.concurrent.IsolationLevel;

@Namespace(uri="urn:infinispan:config:6.0", root="infinispan")
public class Parser60
implements ConfigurationParser {
    public static final String INFINISPAN_FACTORY = "infinispan-factory";

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DEFAULT: {
                    this.parseDefaultCache(reader, holder);
                    continue block5;
                }
                case GLOBAL: {
                    this.parseGlobal(reader, holder);
                    continue block5;
                }
                case NAMED_CACHE: {
                    this.parseNamedCache(reader, holder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseNamedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder defaultBuilder;
        ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String name = "";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
        if (builder == null) {
            builder = holder.newConfigurationBuilder(name);
        }
        if ((defaultBuilder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("___defaultcache")) != null) {
            builder.read(defaultBuilder.build());
        }
        this.parseCache(reader, holder);
    }

    private void parseDefaultCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("___defaultcache");
        if (builder == null) {
            holder.newConfigurationBuilder("___defaultcache");
        }
        this.parseCache(reader, holder);
    }

    private void parseCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block20: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTERING: {
                    this.parseClustering(reader, holder);
                    continue block20;
                }
                case CUSTOM_INTERCEPTORS: {
                    this.parseCustomInterceptors(reader, holder);
                    continue block20;
                }
                case DATA_CONTAINER: {
                    this.parseDataContainer(reader, holder);
                    continue block20;
                }
                case DEADLOCK_DETECTION: {
                    this.parseDeadlockDetection(reader, holder);
                    continue block20;
                }
                case EVICTION: {
                    this.parseEviction(reader, holder);
                    continue block20;
                }
                case EXPIRATION: {
                    this.parseExpiration(reader, holder);
                    continue block20;
                }
                case INDEXING: {
                    this.parseIndexing(reader, holder);
                    continue block20;
                }
                case INVOCATION_BATCHING: {
                    this.parseInvocationBatching(reader, holder);
                    continue block20;
                }
                case JMX_STATISTICS: {
                    this.parseJmxStatistics(reader, holder);
                    continue block20;
                }
                case PERSISTENCE: {
                    this.parsePersistence(reader, holder);
                    continue block20;
                }
                case LOCKING: {
                    this.parseLocking(reader, holder);
                    continue block20;
                }
                case MODULES: {
                    this.parseModules(reader, holder);
                    continue block20;
                }
                case LAZY_DESERIALIZATION: 
                case STORE_AS_BINARY: {
                    this.parseStoreAsBinary(reader, holder);
                    continue block20;
                }
                case TRANSACTION: {
                    this.parseTransaction(reader, holder);
                    continue block20;
                }
                case UNSAFE: {
                    this.parseUnsafe(reader, holder);
                    continue block20;
                }
                case VERSIONING: {
                    this.parseVersioning(reader, holder);
                    continue block20;
                }
                case SITES: {
                    this.parseLocalSites(reader, holder);
                    continue block20;
                }
                case COMPATIBILITY: {
                    this.parseCompatibility(reader, holder);
                    continue block20;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseModules(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
    }

    private void parseVersioning(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        builder.versioning().disable();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    builder.versioning().scheme(VersioningScheme.valueOf((String)value));
                    continue block4;
                }
                case ENABLED: {
                    builder.versioning().enable();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseGlobalSites(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder gcb = holder.getGlobalConfigurationBuilder();
        ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (String)"local");
        String value = reader.getAttributeValue(0);
        gcb.site().localSite(value);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLocalSites(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder ccb = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        boolean isEmptyTag = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            isEmptyTag = true;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUPS: {
                    ccb.sites().backups().clear();
                    this.parseBackups(reader, ccb);
                    continue block4;
                }
                case BACKUP_FOR: {
                    this.parseBackupFor(reader, ccb);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!isEmptyTag) {
            ccb.sites().backups().clear();
            ccb.sites().backupFor().reset();
        }
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ConfigurationBuilder ccb) throws XMLStreamException {
        ccb.sites().backupFor().reset();
        BackupForBuilder backupForBuilder = ccb.sites().backupFor();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_SITE: {
                    backupForBuilder.remoteSite(value);
                    continue block4;
                }
                case REMOTE_CACHE: {
                    backupForBuilder.remoteCache(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseBackups(XMLExtendedStreamReader reader, ConfigurationBuilder ccb) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, ccb);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseBackup(XMLExtendedStreamReader reader, ConfigurationBuilder ccb) throws XMLStreamException {
        BackupConfigurationBuilder backup = ccb.sites().addBackup();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TIMEOUT: {
                    backup.replicationTimeout(Long.parseLong(value));
                    continue block9;
                }
                case STRATEGY: {
                    backup.strategy(BackupConfiguration.BackupStrategy.valueOf((String)value));
                    continue block9;
                }
                case SITE: {
                    backup.site(value);
                    continue block9;
                }
                case BACKUP_FAILURE_POLICY: {
                    backup.backupFailurePolicy(BackupFailurePolicy.valueOf((String)value));
                    continue block9;
                }
                case USE_TWO_PHASE_COMMIT: {
                    backup.useTwoPhaseCommit(Boolean.parseBoolean(value));
                    continue block9;
                }
                case FAILURE_POLICY_CLASS: {
                    backup.failurePolicyClass(value);
                    continue block9;
                }
                case ENABLED: {
                    backup.enabled(Boolean.parseBoolean(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        this.parseTakeOffline(reader, backup);
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        int count = 0;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ++count;
            Element takeOffline = Element.forName(reader.getLocalName());
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case AFTER_FAILURES: {
                        backup.takeOffline().afterFailures(Integer.parseInt(value));
                        continue block5;
                    }
                    case MIN_TIME_TO_WAIT: {
                        backup.takeOffline().minTimeToWait(Long.parseLong(value));
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLStreamReader)reader);
        }
        if (count > 1) {
            throw new CacheConfigurationException("Only one 'takeOffline' element allowed within a 'backup'");
        }
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        boolean forceSetTransactional = false;
        boolean transactionModeSpecified = false;
        block19: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.parseBoolean(value));
                    continue block19;
                }
                case CACHE_STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block19;
                }
                case EAGER_LOCK_SINGLE_NODE: {
                    Parser60.warnRemovedAttribute(Element.TRANSACTION.getLocalName(), Attribute.EAGER_LOCK_SINGLE_NODE.getLocalName());
                    continue block19;
                }
                case LOCKING_MODE: {
                    builder.transaction().lockingMode(LockingMode.valueOf((String)value));
                    continue block19;
                }
                case SYNC_COMMIT_PHASE: {
                    Parser60.warnRemovedAttribute(Element.TRANSACTION.getLocalName(), Attribute.SYNC_COMMIT_PHASE.getLocalName());
                    continue block19;
                }
                case SYNC_ROLLBACK_PHASE: {
                    Parser60.warnRemovedAttribute(Element.TRANSACTION.getLocalName(), Attribute.SYNC_ROLLBACK_PHASE.getLocalName());
                    continue block19;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    forceSetTransactional = true;
                    continue block19;
                }
                case TRANSACTION_MODE: {
                    builder.transaction().transactionMode(TransactionMode.valueOf((String)value));
                    transactionModeSpecified = true;
                    continue block19;
                }
                case USE_EAGER_LOCKING: {
                    Parser60.warnRemovedAttribute(Element.TRANSACTION.getLocalName(), Attribute.USE_EAGER_LOCKING.getLocalName());
                    continue block19;
                }
                case USE_SYNCHRONIZAION: {
                    builder.transaction().useSynchronization(Boolean.parseBoolean(value));
                    continue block19;
                }
                case USE_1PC_FOR_AUTOCOMMIT_TX: {
                    builder.transaction().use1PcForAutoCommitTransactions(Boolean.parseBoolean(value));
                    continue block19;
                }
                case REAPER_WAKE_UP_INTERVAL: {
                    builder.transaction().reaperWakeUpInterval(Long.parseLong(value));
                    continue block19;
                }
                case COMPLETED_TX_TIMEOUT: {
                    builder.transaction().completedTxTimeout(Long.parseLong(value));
                    continue block19;
                }
                case TRANSACTION_PROTOCOL: {
                    builder.transaction().transactionProtocol(TransactionProtocol.valueOf((String)value));
                    continue block19;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        if (!transactionModeSpecified && forceSetTransactional) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        block20: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RECOVERY: {
                    this.parseRecovery(reader, holder);
                    continue block20;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseRecovery(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        RecoveryConfigurationBuilder recovery = holder.getCurrentConfigurationBuilder().transaction().recovery();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        recovery.enable();
                        continue block4;
                    }
                    recovery.disable();
                    continue block4;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    recovery.recoveryInfoCacheName(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseUnsafe(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case UNRELIABLE_RETURN_VALUES: {
                    builder.unsafe().unreliableReturnValues(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseStoreAsBinary(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean binaryKeys = null;
        Boolean binaryValues = null;
        builder.memory().storageType(StorageType.BINARY);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) break;
                    builder.memory().storageType(StorageType.OBJECT);
                    break;
                }
                case STORE_KEYS_AS_BINARY: {
                    binaryKeys = Boolean.parseBoolean(value);
                    break;
                }
                case STORE_VALUES_AS_BINARY: {
                    binaryValues = Boolean.parseBoolean(value);
                    break;
                }
                case DEFENSIVE: {
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            if (binaryKeys == null || binaryKeys.booleanValue() || binaryValues == null || binaryValues.booleanValue()) continue;
            builder.memory().storageType(StorageType.OBJECT);
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block8;
                }
                case ISOLATION_LEVEL: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf((String)value));
                    continue block8;
                }
                case LOCK_ACQUISITION_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block8;
                }
                case USE_LOCK_STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block8;
                }
                case WRITE_SKEW_CHECK: {
                    continue block8;
                }
                case SUPPORTS_CONCURRENT_UPDATES: {
                    builder.locking().supportsConcurrentUpdates(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parsePersistence(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.persistence().passivation(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_STORE: {
                    this.parseClusterLoader(reader, holder);
                    continue block9;
                }
                case SINGLE_FILE_STORE: {
                    this.parseSingleFileStore(reader, holder);
                    continue block9;
                }
                case STORE: {
                    this.parseStore(reader, holder);
                    continue block9;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseSingleFileStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        SingleFileStoreConfigurationBuilder storeBuilder = builder.persistence().addSingleFileStore();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case LOCATION: {
                    storeBuilder.location(value);
                    continue block4;
                }
                case MAX_ENTRIES: {
                    storeBuilder.maxEntries(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    Parser60.parseCommonStoreAttributes(reader, (StoreConfigurationBuilder)storeBuilder, attrName, value, i);
                }
            }
        }
        this.parseStoreChildren(reader, (StoreConfigurationBuilder<?, ?>)storeBuilder);
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ClusterLoaderConfigurationBuilder cclb = builder.persistence().addClusterLoader();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case REMOTE_CALL_TIMEOUT: {
                    cclb.remoteCallTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    Parser60.parseCommonStoreAttributes(reader, (StoreConfigurationBuilder)cclb, attrName, value, i);
                }
            }
        }
        this.parseLoaderChildren(reader, (StoreConfigurationBuilder<?, ?>)cclb);
    }

    public static void parseCommonStoreAttributes(XMLExtendedStreamReader reader, StoreConfigurationBuilder builder, String attributeName, String value, int i) throws XMLStreamException {
        switch (Attribute.forName(attributeName)) {
            case FETCH_PERSISTENT_STATE: {
                builder.fetchPersistentState(Boolean.valueOf(value).booleanValue());
                break;
            }
            case IGNORE_MODIFICATIONS: {
                builder.ignoreModifications(Boolean.valueOf(value).booleanValue());
                break;
            }
            case PURGE_ON_STARTUP: {
                builder.purgeOnStartup(Boolean.valueOf(value).booleanValue());
                break;
            }
            case PRELOAD: {
                builder.preload(Boolean.parseBoolean(value));
                break;
            }
            case SHARED: {
                builder.shared(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
            }
        }
    }

    private void parseStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        CacheLoader store = null;
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Boolean preload = null;
        Boolean shared = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store = (CacheLoader)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block8;
                }
                case FETCH_PERSISTENT_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block8;
                }
                case IGNORE_MODIFICATIONS: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGE_ON_STARTUP: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block8;
                }
                case PRELOAD: {
                    preload = Boolean.parseBoolean(value);
                    continue block8;
                }
                case SHARED: {
                    shared = Boolean.parseBoolean(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        if (store != null) {
            SingleFileStoreConfigurationBuilder storeConfigurationBuilder = null;
            if (store instanceof SingleFileStore) {
                storeConfigurationBuilder = builder.persistence().addSingleFileStore();
                this.parseStoreChildren(reader, (StoreConfigurationBuilder<?, ?>)storeConfigurationBuilder);
            } else if (store instanceof ClusterLoader) {
                storeConfigurationBuilder = builder.persistence().addClusterLoader();
                this.parseLoaderChildren(reader, (StoreConfigurationBuilder<?, ?>)storeConfigurationBuilder);
            }
            if (storeConfigurationBuilder != null) {
                if (fetchPersistentState != null) {
                    storeConfigurationBuilder.fetchPersistentState(fetchPersistentState.booleanValue());
                }
                if (ignoreModifications != null) {
                    storeConfigurationBuilder.ignoreModifications(ignoreModifications.booleanValue());
                }
                if (purgeOnStartup != null) {
                    storeConfigurationBuilder.purgeOnStartup(purgeOnStartup.booleanValue());
                }
                if (preload != null) {
                    storeConfigurationBuilder.preload(preload.booleanValue());
                }
                if (shared != null) {
                    storeConfigurationBuilder.shared(shared.booleanValue());
                }
            }
        }
    }

    private void parseLoaderChildren(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> loaderBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser60.parseCommonLoaderChildren(reader, loaderBuilder);
        }
    }

    public static void parseCommonLoaderChildren(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> loaderBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case PROPERTIES: {
                loaderBuilder.withProperties(Parser60.parseProperties(reader));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseStoreChildren(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser60.parseCommonStoreChildren(reader, storeBuilder);
        }
    }

    public static void parseCommonStoreChildren(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ASYNC: {
                Parser60.parseAsyncStore(reader, storeBuilder);
                break;
            }
            case PROPERTIES: {
                storeBuilder.withProperties(Parser60.parseProperties(reader));
                break;
            }
            case SINGLETON_STORE: {
                Parser60.parseSingletonStore(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public static void parseSingletonStore(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        storeBuilder.singleton().enable();
                        continue block5;
                    }
                    storeBuilder.singleton().disable();
                    continue block5;
                }
                case PUSH_STATE_TIMEOUT: {
                    storeBuilder.singleton().pushStateTimeout(Long.parseLong(value));
                    continue block5;
                }
                case PUSH_STATE_WHEN_COORDINATOR: {
                    storeBuilder.singleton().pushStateWhenCoordinator(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    public static void parseAsyncStore(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        storeBuilder.async().enable();
                        continue block7;
                    }
                    storeBuilder.async().disable();
                    continue block7;
                }
                case FLUSH_LOCK_TIMEOUT: {
                    storeBuilder.async().flushLockTimeout(Long.parseLong(value));
                    continue block7;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.async().modificationQueueSize(Integer.parseInt(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    storeBuilder.async().shutdownTimeout(Long.parseLong(value));
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.async().threadPoolSize(Integer.parseInt(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseJmxStatistics(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.jmxStatistics().enable();
                        continue block3;
                    }
                    builder.jmxStatistics().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseInvocationBatching(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.invocationBatching().enable();
                        continue block3;
                    }
                    builder.invocationBatching().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.indexing().enable();
                        continue block7;
                    }
                    builder.indexing().disable();
                    continue block7;
                }
                case INDEX_LOCAL_ONLY: {
                    builder.indexing().indexLocalOnly(Boolean.parseBoolean(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        Properties indexingProperties = null;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    indexingProperties = Parser60.parseProperties(reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        IndexingConfigurationBuilder indexing = builder.indexing();
        if (indexingProperties != null) {
            indexing.withProperties(indexingProperties);
        }
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block6;
                }
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block6;
                }
                case REAPER_ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.expiration().enableReaper();
                        continue block6;
                    }
                    builder.expiration().disableReaper();
                    continue block6;
                }
                case WAKE_UP_INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_ENTRIES: {
                    builder.memory().size((long)Integer.parseInt(value));
                    continue block4;
                }
                case STRATEGY: 
                case THREAD_POLICY: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseDeadlockDetection(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: 
                case SPIN_DURATION: {
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseDataContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    builder.dataContainer().dataContainer((DataContainer)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block8;
                }
                case KEY_EQUIVALENCE: {
                    builder.dataContainer().keyEquivalence((Equivalence)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block8;
                }
                case VALUE_EQUIVALENCE: {
                    builder.dataContainer().valueEquivalence((Equivalence)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.dataContainer().withProperties(Parser60.parseProperties(reader));
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseCustomInterceptors(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseInterceptor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block12;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block12;
                }
                case CLASS: {
                    try {
                        interceptorBuilder.interceptorClass(Util.loadClassStrict((String)value, (ClassLoader)holder.getClassLoader()).asSubclass(CommandInterceptor.class));
                        continue block12;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.parseInt(value));
                    continue block12;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf((String)value.toUpperCase()));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    interceptorBuilder.withProperties(Parser60.parseProperties(reader));
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseClustering(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        String clusteringMode = null;
        boolean synchronous = false;
        boolean asynchronous = false;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MODE: {
                    clusteringMode = value;
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC: {
                    asynchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseAsync(reader, holder);
                    continue block11;
                }
                case HASH: {
                    this.parseHash(reader, holder);
                    continue block11;
                }
                case L1: {
                    this.parseL1reader(reader, holder.getCurrentConfigurationBuilder());
                    continue block11;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, holder.getCurrentConfigurationBuilder());
                    continue block11;
                }
                case SYNC: {
                    synchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseSync(reader, builder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!synchronous && !asynchronous) {
            this.setMode(builder, clusteringMode, asynchronous, asynchronous, reader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMode(ConfigurationBuilder builder, String clusteringMode, boolean asynchronous, boolean synchronous, XMLExtendedStreamReader reader) {
        if (synchronous && asynchronous) {
            throw new CacheConfigurationException("Cannot configure <sync> and <async> on the same cluster, " + reader.getLocation());
        }
        if (clusteringMode != null) {
            String mode = clusteringMode.toUpperCase();
            if (ParsedCacheMode.REPL.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.REPL_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.INVALIDATION.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.DIST.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
                }
                return;
            } else {
                if (!ParsedCacheMode.LOCAL.matches(mode)) throw new CacheConfigurationException("Invalid clustering mode " + clusteringMode + ", " + reader.getLocation());
                builder.clustering().cacheMode(CacheMode.LOCAL);
            }
            return;
        } else if (synchronous) {
            builder.clustering().cacheMode(CacheMode.DIST_SYNC);
            return;
        } else {
            if (!asynchronous) return;
            builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
        }
    }

    private void parseSync(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REPL_TIMEOUT: {
                    builder.clustering().sync().replTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FETCH_IN_MEMORY_STATE: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block6;
                }
                case AWAIT_INITIAL_TRANSFER: {
                    builder.clustering().stateTransfer().awaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseL1reader(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().l1().enable();
                        continue block7;
                    }
                    builder.clustering().l1().disable();
                    continue block7;
                }
                case INVALIDATION_THRESHOLD: {
                    builder.clustering().l1().invalidationThreshold(Integer.parseInt(value));
                    continue block7;
                }
                case LIFESPAN: {
                    builder.clustering().l1().lifespan(Long.parseLong(value));
                    continue block7;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(Long.parseLong(value));
                    continue block7;
                }
                case ON_REHASH: {
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseHash(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                case HASH_FUNCTION_CLASS: {
                    builder.clustering().hash().hash((Hash)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                case NUM_OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block10;
                }
                case NUM_SEGMENTS: {
                    builder.clustering().hash().numSegments(Integer.parseInt(value));
                    continue block10;
                }
                case CAPACITY_FACTOR: {
                    builder.clustering().hash().capacityFactor(Float.parseFloat(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, holder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String value;
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (String)"enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement((XMLStreamReader)reader, (String)"class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseAsync(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ASYNC_MARSHALLING: {
                    Parser60.warnRemovedAttribute(Element.ASYNC.getLocalName(), attribute.getLocalName());
                    continue block7;
                }
                case REPL_QUEUE_CLASS: {
                    Parser60.warnRemovedAttribute(Element.ASYNC.getLocalName(), attribute.getLocalName());
                    continue block7;
                }
                case REPL_QUEUE_INTERVAL: {
                    Parser60.warnRemovedAttribute(Element.ASYNC.getLocalName(), attribute.getLocalName());
                    continue block7;
                }
                case REPL_QUEUE_MAX_ELEMENTS: {
                    Parser60.warnRemovedAttribute(Element.ASYNC.getLocalName(), attribute.getLocalName());
                    continue block7;
                }
                case USE_REPL_QUEUE: {
                    Parser60.warnRemovedAttribute(Element.ASYNC.getLocalName(), attribute.getLocalName());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseGlobal(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        boolean transportParsed = false;
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(INFINISPAN_FACTORY, new ThreadGroup("infinispan"), 1, "%G %i", null, null);
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_LISTENER_EXECUTOR: {
                    ThreadPoolExecutorFactory executorFactory = this.createBlockingThreadPoolExecutorFactory(this.parseExecutor(reader));
                    holder.getGlobalConfigurationBuilder().listenerThreadPool().threadFactory((ThreadFactory)threadFactory).threadPoolFactory(executorFactory);
                    continue block15;
                }
                case PERSISTENCE_EXECUTOR: {
                    ThreadPoolExecutorFactory executorFactory = this.createBlockingThreadPoolExecutorFactory(this.parseExecutor(reader));
                    holder.getGlobalConfigurationBuilder().persistenceThreadPool().threadFactory((ThreadFactory)threadFactory).threadPoolFactory(executorFactory);
                    continue block15;
                }
                case ASYNC_TRANSPORT_EXECUTOR: {
                    ThreadPoolExecutorFactory executorFactory = this.createBlockingThreadPoolExecutorFactory(this.parseExecutor(reader));
                    holder.getGlobalConfigurationBuilder().transport().transportThreadPool().threadFactory((ThreadFactory)threadFactory).threadPoolFactory(executorFactory);
                    continue block15;
                }
                case REMOTE_COMMAND_EXECUTOR: {
                    ThreadPoolExecutorFactory executorFactory = this.createBlockingThreadPoolExecutorFactory(this.parseExecutor(reader));
                    holder.getGlobalConfigurationBuilder().transport().remoteCommandThreadPool().threadFactory((ThreadFactory)threadFactory).threadPoolFactory(executorFactory);
                    continue block15;
                }
                case EVICTION_SCHEDULED_EXECUTOR: {
                    ThreadPoolExecutorFactory executorFactory = this.createScheduledThreadPoolExecutorFactory(this.parseExecutor(reader));
                    holder.getGlobalConfigurationBuilder().expirationThreadPool().threadFactory((ThreadFactory)threadFactory).threadPoolFactory(executorFactory);
                    continue block15;
                }
                case GLOBAL_JMX_STATISTICS: {
                    this.parseGlobalJMXStatistics(reader, holder);
                    continue block15;
                }
                case MODULES: {
                    this.parseModules(reader, holder);
                    continue block15;
                }
                case REPLICATION_QUEUE_SCHEDULED_EXECUTOR: {
                    Parser60.warnRemovedElement(element.getLocalName());
                    this.parseExecutor(reader);
                    continue block15;
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, holder);
                    continue block15;
                }
                case SHUTDOWN: {
                    this.parseShutdown(reader, holder);
                    continue block15;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    transportParsed = true;
                    continue block15;
                }
                case SITE: {
                    this.parseGlobalSites(reader, holder);
                    continue block15;
                }
                case TOTAL_ORDER_EXECUTOR: {
                    Parser60.warnRemovedElement(element.getLocalName());
                    this.parseExecutor(reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!transportParsed) {
            builder.transport().transport(null);
        } else if (builder.transport().getTransport() == null) {
            builder.transport().defaultTransport();
        }
    }

    private ThreadPoolExecutorFactory createBlockingThreadPoolExecutorFactory(TypedProperties tp) {
        int maxThreads = tp.getIntProperty("maxThreads", 1);
        int queueSize = tp.getIntProperty("queueSize", 100000);
        int coreThreads = queueSize == 0 ? 1 : tp.getIntProperty("coreThreads", maxThreads);
        long keepAliveTime = tp.getLongProperty("keepAliveTime", 60000L);
        return new BlockingThreadPoolExecutorFactory(maxThreads, coreThreads, queueSize, keepAliveTime);
    }

    private ThreadPoolExecutorFactory createCachedThreadPoolExecutorFactory(TypedProperties tp) {
        return CachedThreadPoolExecutorFactory.create();
    }

    private ThreadPoolExecutorFactory createScheduledThreadPoolExecutorFactory(TypedProperties tp) {
        return ScheduledThreadPoolExecutorFactory.create();
    }

    private void parseTransport(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLUSTER_NAME: {
                    builder.transport().clusterName(value);
                    continue block13;
                }
                case DISTRIBUTED_SYNC_TIMEOUT: {
                    builder.transport().distributedSyncTimeout(Long.parseLong(value));
                    continue block13;
                }
                case MACHINE_ID: {
                    builder.transport().machineId(value);
                    continue block13;
                }
                case NODE_NAME: {
                    builder.transport().nodeName(value);
                    continue block13;
                }
                case RACK_ID: {
                    builder.transport().rackId(value);
                    continue block13;
                }
                case SITE_ID: {
                    builder.transport().siteId(value);
                    continue block13;
                }
                case STRICT_PEER_TO_PEER: {
                    builder.transport().strictPeerToPeer(Boolean.valueOf(value));
                    continue block13;
                }
                case TRANSPORT_CLASS: {
                    builder.transport().transport((Transport)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    Properties properties = Parser60.parseProperties(reader);
                    if (properties.containsKey("configurationFile")) {
                        String stackFile = (String)properties.remove("configurationFile");
                        properties.put("stack", "jgroups");
                        properties.put("stack-jgroups", "jgroups");
                        properties.put("stackFilePath-jgroups", stackFile);
                    }
                    builder.transport().withProperties(properties);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseShutdown(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOOK_BEHAVIOR: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf((String)value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSerialization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case VERSION: {
                    builder.serialization().version(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZERS: {
                    this.parseAdvancedExternalizers(reader, holder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseAdvancedExternalizers(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    int attributes = reader.getAttributeCount();
                    AdvancedExternalizer advancedExternalizer = null;
                    Integer id = null;
                    ParseUtils.requireAttributes((XMLStreamReader)reader, (String[])new String[]{Attribute.EXTERNALIZER_CLASS.getLocalName()});
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case EXTERNALIZER_CLASS: {
                                advancedExternalizer = (AdvancedExternalizer)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                                continue block8;
                            }
                            case ID: {
                                id = Integer.valueOf(value);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLStreamReader)reader);
                    if (id != null) {
                        builder.serialization().addAdvancedExternalizer(id.intValue(), advancedExternalizer);
                        continue block7;
                    }
                    builder.serialization().addAdvancedExternalizer(advancedExternalizer);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseGlobalJMXStatistics(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALLOW_DUPLICATE_DOMAINS: {
                    builder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(value));
                    continue block10;
                }
                case CACHE_MANAGER_NAME: {
                    builder.globalJmxStatistics().cacheManagerName(value);
                    continue block10;
                }
                case ENABLED: {
                    if (!Boolean.parseBoolean(value)) {
                        builder.globalJmxStatistics().disable();
                        continue block10;
                    }
                    builder.globalJmxStatistics().enable();
                    continue block10;
                }
                case JMX_DOMAIN: {
                    builder.globalJmxStatistics().jmxDomain(value);
                    continue block10;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.globalJmxStatistics().withProperties(Parser60.parseProperties(reader));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private TypedProperties parseExecutor(XMLExtendedStreamReader reader) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        Properties properties = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    properties = Parser60.parseProperties(reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        return TypedProperties.toTypedProperties((Properties)properties);
    }

    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        Properties p = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    ParseUtils.requireAttributes((XMLStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    String key = null;
                    String propertyValue = null;
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                key = value;
                                continue block8;
                            }
                            case VALUE: {
                                propertyValue = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                            }
                        }
                    }
                    p.put(key, propertyValue);
                    ParseUtils.requireNoContent((XMLStreamReader)reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        return p;
    }

    private void parseCompatibility(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.compatibility().enabled(Boolean.parseBoolean(value));
                    continue block4;
                }
                case MARSHALLER_CLASS: {
                    builder.compatibility().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    public static void warnRemovedAttribute(String element, String attribute) {
        System.err.printf("Warning: attribute '%s' on element '%s' has been removed%n", attribute, element);
    }

    public static void warnRemovedElement(String element) {
        System.err.printf("Warning: element '%s' has been removed%n", element);
    }
}

