/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.PrincipalNameResolver;
import org.infinispan.spring.remote.session.RemoteApplicationPublishedBridge;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

public class InfinispanRemoteSessionRepository
extends AbstractInfinispanSessionRepository {
    public InfinispanRemoteSessionRepository(SpringCache cache) {
        super(cache, (AbstractApplicationPublisherBridge)new RemoteApplicationPublishedBridge(cache));
    }

    protected void removeFromCacheWithoutNotifications(String originalId) {
        RemoteCache remoteCache = (RemoteCache)this.cache.getNativeCache();
        if (this.cache.getWriteTimeout() > 0L) {
            try {
                remoteCache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeAsync((Object)originalId).get(this.cache.getWriteTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException((Throwable)e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new CacheException((Throwable)e);
            }
        } else {
            remoteCache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)originalId);
        }
    }

    public Map<String, MapSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        return this.cache.getNativeCache().values().stream().map(cacheValue -> (MapSession)cacheValue).filter(session -> indexValue.equals(PrincipalNameResolver.getInstance().resolvePrincipal((Session)session))).collect(Collectors.toMap(MapSession::getId, Function.identity()));
    }
}

