/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.util.Objects;
import java.util.Optional;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.spring.common.provider.SpringCache;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;

public abstract class AbstractApplicationPublisherBridge
implements ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(AbstractApplicationPublisherBridge.class);
    protected final SpringCache eventSource;
    protected Optional<ApplicationEventPublisher> springEventsPublisher = Optional.empty();

    protected AbstractApplicationPublisherBridge(SpringCache eventSource) {
        Objects.requireNonNull(eventSource);
        this.eventSource = eventSource;
    }

    protected abstract void registerListener();

    public abstract void unregisterListener();

    protected void emitSessionCreatedEvent(Session session) {
        logger.debugf("Emitting session created %s", (Object)session.getId());
        this.springEventsPublisher.ifPresent(p -> p.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this.eventSource, session)));
    }

    protected void emitSessionExpiredEvent(Session session) {
        logger.debugf("Emitting session expired %s", (Object)session.getId());
        this.springEventsPublisher.ifPresent(p -> p.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this.eventSource, session)));
    }

    protected void emitSessionDestroyedEvent(Session session) {
        logger.debugf("Emitting session destroyed %s", (Object)session.getId());
        this.springEventsPublisher.ifPresent(p -> p.publishEvent((ApplicationEvent)new SessionDestroyedEvent((Object)this.eventSource, session)));
    }

    protected void emitSessionDeletedEvent(Session session) {
        logger.debugf("Emitting session deleted %s", (Object)session.getId());
        this.springEventsPublisher.ifPresent(p -> p.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this.eventSource, session)));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.springEventsPublisher = Optional.ofNullable(applicationEventPublisher);
    }
}

